/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.sun.xml.ws.client.ClientTransportException;
import de.gematik.bbriccs.cfg.dto.TLSConfiguration;
import de.gematik.bbriccs.konnektor.KonnektorServiceDefinition;
import de.gematik.bbriccs.konnektor.RemoteKonServicePort;
import de.gematik.bbriccs.konnektor.TrustProvider;
import de.gematik.bbriccs.konnektor.cfg.KonnektorContextConfiguration;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.conn.signatureservice.wsdl.v7.SignatureServicePortType;
import java.net.MalformedURLException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@WireMockTest
class RemoteKonServicePortTest {
    @RegisterExtension
    static WireMockExtension wm1 = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).build();
    private static String url;

    RemoteKonServicePortTest() {
    }

    @BeforeAll
    static void setup() {
        int port = wm1.getPort();
        url = "http://localhost:" + port;
    }

    static Stream<Arguments> shouldProvideServicePortType() {
        return Stream.of(RemoteKonServicePort::getSignatureService, RemoteKonServicePort::getAuthSignatureService, RemoteKonServicePort::getCertificateService, RemoteKonServicePort::getEventService, RemoteKonServicePort::getCardService, RemoteKonServicePort::getCardTerminalService, RemoteKonServicePort::getVSDServicePortType, RemoteKonServicePort::getEncryptionServicePortType).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private void prepareKonnektorSdsResponse() {
        String sds = ResourceLoader.readFileFromResource((String)"sds/cgm_connector_sds.xml");
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/connector.sds")).willReturn(WireMock.aResponse().withBody(sds)));
    }

    @Test
    void shouldFetchSdsOnConnect() {
        this.prepareKonnektorSdsResponse();
        RemoteKonServicePort servicePort = RemoteKonServicePort.onRemote((String)url).build();
        String info = servicePort.toString();
        Assertions.assertTrue((boolean)info.contains(url));
        KonnektorServiceDefinition sds = (KonnektorServiceDefinition)Assertions.assertDoesNotThrow(() -> ((RemoteKonServicePort)servicePort).getSds());
        Assertions.assertTrue((boolean)sds.getProductName().contains("KoCoBox"));
    }

    @Test
    void shouldReThrowOnMalformedUrl() {
        Assertions.assertThrows(MalformedURLException.class, () -> RemoteKonServicePort.onRemote((String)"abc"));
    }

    @ParameterizedTest
    @MethodSource
    <T> void shouldProvideServicePortType(Function<RemoteKonServicePort, T> serviceFetcher) {
        this.prepareKonnektorSdsResponse();
        RemoteKonServicePort servicePort = RemoteKonServicePort.onRemote((String)url).build();
        Object portType = Assertions.assertDoesNotThrow(() -> serviceFetcher.apply(servicePort));
        Assertions.assertNotNull((Object)portType);
    }

    @ParameterizedTest
    @MethodSource(value={"shouldProvideServicePortType"})
    <T> void shouldProvideServicePortType02(Function<RemoteKonServicePort, T> serviceFetcher) {
        TLSConfiguration cfg = new TLSConfiguration();
        cfg.setKeyStore("resources/tls/keystore.p12");
        cfg.setKeyStorePassword("changeit");
        cfg.setTrustStore("resource/tls/truststore.p12");
        cfg.setTrustStorePassword("123456");
        this.prepareKonnektorSdsResponse();
        RemoteKonServicePort servicePort = RemoteKonServicePort.onRemote((String)url).auth("user", "password").hostnameVerifier((hostname, session) -> true).trustProvider(TrustProvider.from((TLSConfiguration)cfg)).build();
        Object portType = Assertions.assertDoesNotThrow(() -> serviceFetcher.apply(servicePort));
        Assertions.assertNotNull((Object)portType);
    }

    @Test
    void shouldVerifyHostname() {
        TLSConfiguration cfg = new TLSConfiguration();
        cfg.setKeyStore("resources/tls/keystore.p12");
        cfg.setKeyStorePassword("changeit");
        cfg.setTrustStore("resource/tls/truststore.p12");
        cfg.setTrustStorePassword("123456");
        this.prepareKonnektorSdsResponse();
        RemoteKonServicePort servicePort = RemoteKonServicePort.onRemote((String)url).auth("user", "password").hostnameVerifier((hostname, session) -> true).trustProvider(TrustProvider.from((TLSConfiguration)cfg)).build();
        ContextType ctx = KonnektorContextConfiguration.getDefaultContextType();
        SignatureServicePortType service = servicePort.getSignatureService();
        Assertions.assertThrows(ClientTransportException.class, () -> service.getJobNumber(ctx));
    }
}

