/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.DefaultRawHttpCodec;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public interface RawHttpCodec {
    public String encode(HttpBRequest var1);

    public String encode(HttpBResponse var1);

    default public String encodeB64(HttpBRequest request) {
        return Base64.getEncoder().encodeToString(this.encode(request).getBytes(StandardCharsets.UTF_8));
    }

    default public String encodeB64(HttpBResponse response) {
        return Base64.getEncoder().encodeToString(this.encode(response).getBytes(StandardCharsets.UTF_8));
    }

    public HttpBResponse decodeResponse(String var1);

    default public HttpBResponse decodeResponse(byte[] rawResponse) {
        return this.decodeResponse(new String(rawResponse, StandardCharsets.UTF_8));
    }

    default public HttpBResponse decodeResponseB64(String b64RawResponse) {
        return this.decodeResponse(Base64.getDecoder().decode(b64RawResponse));
    }

    public HttpBRequest decodeRequest(String var1);

    default public HttpBRequest decodeRequest(byte[] rawRequest) {
        return this.decodeRequest(new String(rawRequest, StandardCharsets.UTF_8));
    }

    default public HttpBRequest decodeRequestB64(String b64RawRequest) {
        return this.decodeRequest(Base64.getDecoder().decode(b64RawRequest));
    }

    public static RawHttpCodec defaultCodec() {
        return new DefaultRawHttpCodec();
    }
}

