/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import com.google.common.base.Strings;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.RawHttpCodec;
import de.gematik.bbriccs.rest.ReasonPhrase;
import de.gematik.bbriccs.rest.exceptions.RawHttpCodecException;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRawHttpCodec
implements RawHttpCodec {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRawHttpCodec.class);
    private static final Pattern STATUS_LINE_REGEX_PATTERN = Pattern.compile("(HTTP/\\S{1,3})\\s(\\d{3})(\\w*)");
    private static final String LINE_BREAK = "\r\n";
    private static final String DOUBLE_LINE_BREAK = "\r\n\r\n";

    @Override
    public String encode(HttpBRequest request) {
        StringBuilder ret = new StringBuilder();
        ret.append(request.method()).append(" ").append(request.urlPath()).append(" ").append(request.version()).append(LINE_BREAK);
        request.headers().forEach(h -> ret.append(h.key()).append(": ").append(h.value()).append(LINE_BREAK));
        ret.append(LINE_BREAK);
        if (!request.isEmptyBody()) {
            ret.append(request.bodyAsString());
        }
        log.trace("Encoded HTTP Request:\n----------\n{}\n----------", (Object)ret);
        return ret.toString();
    }

    @Override
    public String encode(HttpBResponse response) {
        StringBuilder ret = new StringBuilder();
        ret.append(response.version().version).append(" ").append(response.statusCode()).append(" ").append(ReasonPhrase.fromStatusCode(response.statusCode()).getReasonPhrase()).append(LINE_BREAK);
        response.headers().forEach(h -> ret.append(h.key()).append(": ").append(h.value()).append(LINE_BREAK));
        if (!response.isEmptyBody()) {
            ret.append(LINE_BREAK).append(response.bodyAsString());
        }
        log.trace("Encoded HTTP Response:\n----------\n{}\n----------", (Object)ret);
        return ret.toString();
    }

    @Override
    public HttpBResponse decodeResponse(String rawResponse) {
        if (Strings.isNullOrEmpty((String)rawResponse)) {
            throw new RawHttpCodecException(MessageFormat.format("response is not parsable, Response: {0}", rawResponse));
        }
        String[] rawHttpParts = rawResponse.split(DOUBLE_LINE_BREAK);
        String[] genericHttMessageLines = rawHttpParts[0].split(LINE_BREAK);
        String rawStatusLine = genericHttMessageLines[0];
        String[] rawHeaders = new String[genericHttMessageLines.length - 1];
        System.arraycopy(genericHttMessageLines, 1, rawHeaders, 0, rawHeaders.length);
        Pair<HttpVersion, Integer> statusLine = this.splitStatusLine(rawStatusLine);
        List<HttpHeader> headers = this.parseHeader(rawHeaders);
        String body = rawHttpParts.length == 2 ? rawHttpParts[1] : "";
        return new HttpBResponse((HttpVersion)statusLine.getKey(), ((Integer)statusLine.getRight()).intValue(), headers, body);
    }

    @Override
    public HttpBRequest decodeRequest(String rawRequest) {
        if (Strings.isNullOrEmpty((String)rawRequest)) {
            throw new RawHttpCodecException(MessageFormat.format("response is not parsable, Request: {0}", rawRequest));
        }
        String[] rawHttpParts = rawRequest.split(DOUBLE_LINE_BREAK);
        String[] genericHttMessageLines = rawHttpParts[0].split(LINE_BREAK);
        String statusLine = genericHttMessageLines[0];
        String[] rawStatusLineTokens = statusLine.split(" ");
        HttpRequestMethod requestMethod = HttpRequestMethod.valueOf((String)rawStatusLineTokens[0]);
        String urlPath = rawStatusLineTokens[1];
        HttpVersion version = HttpVersion.optionalFromString((String)rawStatusLineTokens[2]).orElse(HttpVersion.HTTP_1_1);
        String[] rawHeaders = new String[genericHttMessageLines.length - 1];
        System.arraycopy(genericHttMessageLines, 1, rawHeaders, 0, rawHeaders.length);
        List<HttpHeader> headers = this.parseHeader(rawHeaders);
        String body = rawHttpParts.length == 2 ? rawHttpParts[1] : "";
        return new HttpBRequest(version, requestMethod, urlPath, headers, body);
    }

    private List<HttpHeader> parseHeader(String[] rawHeader) {
        return Arrays.stream(rawHeader).map(DefaultRawHttpCodec::parseHeaderLine).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Pair<HttpVersion, Integer> splitStatusLine(String statusLine) {
        Matcher matcher = STATUS_LINE_REGEX_PATTERN.matcher(statusLine);
        if (matcher.find()) {
            HttpVersion version = HttpVersion.optionalFromString((String)matcher.group(1)).orElse(HttpVersion.HTTP_1_1);
            Integer statusCode = Optional.ofNullable(matcher.group(2)).map(sc -> Integer.parseInt(sc.trim())).orElseThrow(() -> new RawHttpCodecException("HTTP status code is missing"));
            return Pair.of((Object)version, (Object)statusCode);
        }
        throw new RawHttpCodecException("HTTP status line is invalid or incomplete");
    }

    private static Optional<HttpHeader> parseHeaderLine(String header) {
        String[] headerTokens = header.split(": ?", 2);
        if (headerTokens.length <= 1) {
            log.warn("header structure is invalid: {}", (Object)header);
            return Optional.empty();
        }
        return Optional.of(new HttpHeader(headerTokens[0], headerTokens[1]));
    }

    @Generated
    DefaultRawHttpCodec() {
    }
}

