/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.cardterminal;

import de.gematik.bbriccs.cardterminal.CardInfo;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CardInfoTest {
    CardInfoTest() {
    }

    @Test
    void shouldGetFromCardInfoType() {
        CardInfoType cit = new CardInfoType();
        cit.setCardType(CardTypeType.HBA);
        cit.setCardHandle("handle");
        cit.setIccsn("iccsn");
        cit.setSlotId(BigInteger.ZERO);
        cit.setCtId("ctId");
        cit.setInsertTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        CardInfo ci = (CardInfo)Assertions.assertDoesNotThrow(() -> CardInfo.fromCardInfoType((CardInfoType)cit));
        Assertions.assertEquals((Object)CardTypeType.HBA, (Object)ci.getType());
        Assertions.assertEquals((Object)"handle", (Object)ci.getHandle());
        Assertions.assertEquals((Object)"iccsn", (Object)ci.getIccsn());
        Assertions.assertEquals((int)0, (int)ci.getSlot().intValue());
        Assertions.assertEquals((Object)"ctId", (Object)ci.getCtId());
        Assertions.assertNotNull((Object)ci.getInsertTime());
        Assertions.assertDoesNotThrow(() -> ((CardInfo)ci).toString());
    }
}

