/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.cardterminal;

import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;

public class CardInfo {
    private final String handle;
    private final String iccsn;
    private final BigInteger slot;
    private final String ctId;
    private final CardTypeType type;
    private final GregorianCalendar insertTime;

    public static CardInfo fromCardInfoType(CardInfoType cit) {
        return new CardInfoBuilder().handle(cit.getCardHandle()).iccsn(cit.getIccsn()).slot(cit.getSlotId()).ctId(cit.getCtId()).type(cit.getCardType()).insertTime(Optional.ofNullable(cit.getInsertTime()).map(XMLGregorianCalendar::toGregorianCalendar).orElse(null)).build();
    }

    public String toString() {
        return MessageFormat.format("CardHandle \"{0}\" for {1} with ICCSN {2} in Slot {3}", new Object[]{this.handle, this.type, this.iccsn, this.slot});
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardInfo that = (CardInfo)o;
        return this.iccsn.equals(that.iccsn);
    }

    @Generated
    public int hashCode() {
        return this.iccsn.hashCode();
    }

    @Generated
    CardInfo(String handle, String iccsn, BigInteger slot, String ctId, CardTypeType type, GregorianCalendar insertTime) {
        this.handle = handle;
        this.iccsn = iccsn;
        this.slot = slot;
        this.ctId = ctId;
        this.type = type;
        this.insertTime = insertTime;
    }

    @Generated
    public static CardInfoBuilder builder() {
        return new CardInfoBuilder();
    }

    @Generated
    public String getHandle() {
        return this.handle;
    }

    @Generated
    public String getIccsn() {
        return this.iccsn;
    }

    @Generated
    public BigInteger getSlot() {
        return this.slot;
    }

    @Generated
    public String getCtId() {
        return this.ctId;
    }

    @Generated
    public CardTypeType getType() {
        return this.type;
    }

    @Generated
    public GregorianCalendar getInsertTime() {
        return this.insertTime;
    }

    @Generated
    public static class CardInfoBuilder {
        @Generated
        private String handle;
        @Generated
        private String iccsn;
        @Generated
        private BigInteger slot;
        @Generated
        private String ctId;
        @Generated
        private CardTypeType type;
        @Generated
        private GregorianCalendar insertTime;

        @Generated
        CardInfoBuilder() {
        }

        @Generated
        public CardInfoBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        @Generated
        public CardInfoBuilder iccsn(String iccsn) {
            this.iccsn = iccsn;
            return this;
        }

        @Generated
        public CardInfoBuilder slot(BigInteger slot) {
            this.slot = slot;
            return this;
        }

        @Generated
        public CardInfoBuilder ctId(String ctId) {
            this.ctId = ctId;
            return this;
        }

        @Generated
        public CardInfoBuilder type(CardTypeType type) {
            this.type = type;
            return this;
        }

        @Generated
        public CardInfoBuilder insertTime(GregorianCalendar insertTime) {
            this.insertTime = insertTime;
            return this;
        }

        @Generated
        public CardInfo build() {
            return new CardInfo(this.handle, this.iccsn, this.slot, this.ctId, this.type, this.insertTime);
        }

        @Generated
        public String toString() {
            return "CardInfo.CardInfoBuilder(handle=" + this.handle + ", iccsn=" + this.iccsn + ", slot=" + this.slot + ", ctId=" + this.ctId + ", type=" + this.type + ", insertTime=" + this.insertTime + ")";
        }
    }
}

