/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.util;

import com.github.javafaker.Faker;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservice.v8.Cards;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.eventservice.v7.GetCardsResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import lombok.Generated;

public class CardsUtil {
    private static final Faker faker = new Faker();

    private CardsUtil() {
        throw new AssertionError((Object)"util class");
    }

    public static CardInfoTypeBuilder builder() {
        return new CardInfoTypeBuilder();
    }

    public static GetCardsResponse createGetCardsResponse(Status status, int numCards) {
        ArrayList<CardInfoType> cards = new ArrayList<CardInfoType>();
        for (int i = 0; i < numCards; ++i) {
            cards.add(CardsUtil.builder().type(CardTypeType.EGK).slot(i).build());
        }
        return CardsUtil.createGetCardsResponse(status, cards.toArray(new CardInfoType[cards.size()]));
    }

    public static GetCardsResponse createGetCardsResponse(Status status, CardInfoType ... card) {
        GetCardsResponse gcr = new GetCardsResponse();
        gcr.setStatus(status);
        Cards cards = new Cards();
        cards.getCard().addAll(Arrays.stream(card).toList());
        gcr.setCards(cards);
        return gcr;
    }

    public static class CardInfoTypeBuilder {
        private CardTypeType type;
        private int slot = Integer.parseInt(faker.regexify("[1-4]{1}"));
        private String iccsn = faker.regexify("[0-9]{20}");
        private String ctId = "CT1";
        private String cardHandle = faker.regexify("[A-Za-z0-9]{15}");
        private String cardHolderName = faker.name().fullName();
        private GregorianCalendar insertTime = new GregorianCalendar();

        private CardInfoTypeBuilder() {
        }

        public CardInfoTypeBuilder type(CardTypeType type) {
            this.type = type;
            return this;
        }

        public CardInfoTypeBuilder slot(int slot) {
            this.slot = slot;
            return this;
        }

        public CardInfoTypeBuilder iccsn(String iccsn) {
            this.iccsn = iccsn;
            return this;
        }

        public CardInfoTypeBuilder ctId(String ctId) {
            this.ctId = ctId;
            return this;
        }

        public CardInfoTypeBuilder cardHandle(String cardHandle) {
            this.cardHandle = cardHandle;
            return this;
        }

        public CardInfoTypeBuilder cardHolderName(String cardHolderName) {
            this.cardHolderName = cardHolderName;
            return this;
        }

        public CardInfoTypeBuilder insertTime(GregorianCalendar insertTime) {
            this.insertTime = insertTime;
            return this;
        }

        public CardInfoType build() {
            CardInfoType cit = new CardInfoType();
            cit.setIccsn(this.iccsn);
            cit.setCardType(this.type);
            cit.setCardHandle(this.cardHandle);
            cit.setCardHolderName(this.cardHolderName);
            cit.setInsertTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(this.insertTime));
            cit.setCtId(this.ctId);
            cit.setSlotId(BigInteger.valueOf(this.slot));
            return cit;
        }
    }

    @Generated
    public static class CardsUtilBuilder {
        @Generated
        CardsUtilBuilder() {
        }

        @Generated
        public CardsUtil build() {
            return new CardsUtil();
        }

        @Generated
        public String toString() {
            return "CardsUtil.CardsUtilBuilder()";
        }
    }
}

