/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.requests.options;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.requests.options.SignDocumentOptions;
import de.gematik.bbriccs.konnektor.requests.options.SignatureType;
import de.gematik.bbriccs.konnektor.requests.options.SigningCryptType;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SignDocumentOptionsTest {
    SignDocumentOptionsTest() {
    }

    static Stream<Arguments> shouldProperlyMapCryptoSystem() {
        return Stream.of(Arguments.of((Object[])new Object[]{CryptoSystem.RSA_2048, SigningCryptType.RSA}), Arguments.of((Object[])new Object[]{CryptoSystem.RSA_PSS_2048, SigningCryptType.RSA}), Arguments.of((Object[])new Object[]{CryptoSystem.ECC_256, SigningCryptType.ECC}));
    }

    @Test
    void shouldBuildDefaultOptions() {
        SignDocumentOptions options = SignDocumentOptions.getDefaultOptions();
        Assertions.assertTrue((boolean)options.isIncludeEContent());
        Assertions.assertEquals((Object)SignatureType.RFC_5652, (Object)options.getSignatureType());
        Assertions.assertEquals((Object)"NONE", (Object)options.getTvMode());
        Assertions.assertEquals((Object)"text/plain; charset=utf-8", (Object)options.getMimeType());
        Assertions.assertEquals((Object)SigningCryptType.RSA_ECC, (Object)options.getCryptoType());
    }

    @ParameterizedTest
    @MethodSource
    void shouldProperlyMapCryptoSystem(CryptoSystem input, SigningCryptType expected) {
        SignDocumentOptions rsaOptions = SignDocumentOptions.withAlgorithm((CryptoSystem)input);
        Assertions.assertEquals((Object)expected, (Object)rsaOptions.getCryptoType());
    }
}

