/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.requests;

import de.gematik.bbriccs.konnektor.ServicePort;
import de.gematik.bbriccs.konnektor.exceptions.SOAPRequestException;
import de.gematik.bbriccs.konnektor.requests.AbstractKonnektorRequest;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractKonnektorRequestTest {
    AbstractKonnektorRequestTest() {
    }

    @Test
    void shouldExecuteSupplier() {
        TestSupplierKonnektorRequest request = new TestSupplierKonnektorRequest(false);
        String result = request.execute(null, null);
        Assertions.assertEquals((Object)"okay", (Object)result);
    }

    @Test
    void shouldCatchOnExecuteSupplier() {
        TestSupplierKonnektorRequest request = new TestSupplierKonnektorRequest(true);
        Assertions.assertThrows(SOAPRequestException.class, () -> request.execute(null, null));
    }

    @Test
    void shouldExecuteAction() {
        TestActionKonnektorRequest request = new TestActionKonnektorRequest(false);
        String result = request.execute(null, null);
        Assertions.assertEquals((Object)"okay", (Object)result);
    }

    @Test
    void shouldCatchOnExecuteAction() {
        TestActionKonnektorRequest request = new TestActionKonnektorRequest(true);
        Assertions.assertThrows(SOAPRequestException.class, () -> request.execute(null, null));
    }

    private static class TestSupplierKonnektorRequest
    extends AbstractKonnektorRequest<String> {
        private final boolean showThrow;

        public String execute(ContextType ctx, ServicePort serviceProvider) {
            if (this.showThrow) {
                return (String)this.executeSupplier(null);
            }
            return (String)this.executeSupplier(() -> "okay");
        }

        @Generated
        public TestSupplierKonnektorRequest(boolean showThrow) {
            this.showThrow = showThrow;
        }
    }

    private static class TestActionKonnektorRequest
    extends AbstractKonnektorRequest<String> {
        private final boolean showThrow;
        private final StringBuilder input = new StringBuilder();

        public String execute(ContextType ctx, ServicePort serviceProvider) {
            if (this.showThrow) {
                this.executeAction(null);
            } else {
                this.executeAction(() -> this.input.append("okay"));
            }
            return this.input.toString();
        }

        @Generated
        public TestActionKonnektorRequest(boolean showThrow) {
            this.showThrow = showThrow;
        }
    }
}

