/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.cfg;

import de.gematik.bbriccs.konnektor.KonnektorBuildInstruction;
import de.gematik.bbriccs.konnektor.KonnektorFactory;
import de.gematik.bbriccs.konnektor.cfg.KonnektorConfiguration;
import de.gematik.bbriccs.konnektor.cfg.KonnektorServiceConfiguration;
import de.gematik.bbriccs.konnektor.exceptions.InvalidKonnektorServiceConfigurationException;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KonnektorServiceConfigurationTest {
    KonnektorServiceConfigurationTest() {
    }

    @Test
    void shouldCastToConcreteType() {
        ConcreteKonnektorServiceConfiguration cfg = new ConcreteKonnektorServiceConfiguration();
        cfg.setType("Test Configuration");
        ConcreteKonnektorFactory serviceFactory = new ConcreteKonnektorFactory();
        ConcreteKonnektorServiceConfiguration castedCfg = (ConcreteKonnektorServiceConfiguration)((Object)Assertions.assertDoesNotThrow(() -> (ConcreteKonnektorServiceConfiguration)cfg.castTo(serviceFactory, ConcreteKonnektorServiceConfiguration.class)));
        Assertions.assertEquals((Object)"Test Configuration", (Object)castedCfg.getType());
        Assertions.assertEquals((Object)"test field", (Object)castedCfg.getTestField());
    }

    @Test
    void shouldThrowOnIncompatibleConcreteType() {
        ConcreteKonnektorServiceConfiguration2 cfg = new ConcreteKonnektorServiceConfiguration2();
        cfg.setType("Test Configuration");
        ConcreteKonnektorFactory serviceFactory = new ConcreteKonnektorFactory();
        InvalidKonnektorServiceConfigurationException exception = (InvalidKonnektorServiceConfigurationException)Assertions.assertThrows(InvalidKonnektorServiceConfigurationException.class, () -> cfg.castTo(serviceFactory, ConcreteKonnektorServiceConfiguration.class));
        Assertions.assertTrue((boolean)exception.getMessage().contains(serviceFactory.getType()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(cfg.getType()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(ConcreteKonnektorServiceConfiguration2.class.getSimpleName()));
    }

    private static class ConcreteKonnektorServiceConfiguration
    extends KonnektorServiceConfiguration {
        private String testField = "test field";

        @Generated
        public ConcreteKonnektorServiceConfiguration() {
        }

        @Generated
        public String getTestField() {
            return this.testField;
        }

        @Generated
        public void setTestField(String testField) {
            this.testField = testField;
        }

        @Generated
        public String toString() {
            return "KonnektorServiceConfigurationTest.ConcreteKonnektorServiceConfiguration(testField=" + this.getTestField() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConcreteKonnektorServiceConfiguration)) {
                return false;
            }
            ConcreteKonnektorServiceConfiguration other = (ConcreteKonnektorServiceConfiguration)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$testField = this.getTestField();
            String other$testField = other.getTestField();
            return !(this$testField == null ? other$testField != null : !this$testField.equals(other$testField));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConcreteKonnektorServiceConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $testField = this.getTestField();
            result = result * 59 + ($testField == null ? 43 : $testField.hashCode());
            return result;
        }
    }

    private static class ConcreteKonnektorFactory
    implements KonnektorFactory {
        private ConcreteKonnektorFactory() {
        }

        public String getType() {
            return "Test Factory";
        }

        public KonnektorBuildInstruction mapConfiguration(KonnektorConfiguration cfg) {
            return null;
        }
    }

    private static class ConcreteKonnektorServiceConfiguration2
    extends KonnektorServiceConfiguration {
        private String testField2 = "test field2";

        @Generated
        public ConcreteKonnektorServiceConfiguration2() {
        }

        @Generated
        public String getTestField2() {
            return this.testField2;
        }

        @Generated
        public void setTestField2(String testField2) {
            this.testField2 = testField2;
        }

        @Generated
        public String toString() {
            return "KonnektorServiceConfigurationTest.ConcreteKonnektorServiceConfiguration2(testField2=" + this.getTestField2() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConcreteKonnektorServiceConfiguration2)) {
                return false;
            }
            ConcreteKonnektorServiceConfiguration2 other = (ConcreteKonnektorServiceConfiguration2)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$testField2 = this.getTestField2();
            String other$testField2 = other.getTestField2();
            return !(this$testField2 == null ? other$testField2 != null : !this$testField2.equals(other$testField2));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConcreteKonnektorServiceConfiguration2;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $testField2 = this.getTestField2();
            result = result * 59 + ($testField2 == null ? 43 : $testField2.hashCode());
            return result;
        }
    }
}

