/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.KonnektorServiceDefinition;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.ws.conn.servicedirectory.ConnectorServices;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class KonnektorServiceDefinitionTest {
    KonnektorServiceDefinitionTest() {
    }

    static Stream<Arguments> shouldReadSds() {
        return ResourceLoader.getResourceFilesInDirectory((String)"sds").stream().map(f -> Arguments.of((Object[])new Object[]{KonnektorServiceDefinitionTest.readSds("sds/" + f.getName())}));
    }

    private static ConnectorServices readSds(String fileName) {
        InputStream sds = ResourceLoader.getFileFromResourceAsStream((String)fileName);
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{ConnectorServices.class});
        Unmarshaller unmarshaller = jaxb.createUnmarshaller();
        return (ConnectorServices)unmarshaller.unmarshal((Reader)new BufferedReader(new InputStreamReader(sds)));
    }

    @Test
    void shouldCreateFromConnectorSds() {
        ConnectorServices connectorServices = KonnektorServiceDefinitionTest.readSds("sds/rise_connector_sds.xml");
        KonnektorServiceDefinition ksd = KonnektorServiceDefinition.from((ConnectorServices)connectorServices);
        Assertions.assertNotNull((Object)ksd);
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/cardservice", (Object)ksd.getCardService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/certificateservice", (Object)ksd.getCertificateService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/eventservice", (Object)ksd.getEventService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/encryptionservice", (Object)ksd.getEncryptionService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/cardterminalservice", (Object)ksd.getCardTerminalService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/authsignatureservice", (Object)ksd.getAuthSignatureService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/webservices/signatureservice/v7.5", (Object)ksd.getSignatureService());
        Assertions.assertEquals((Object)"https://ksp.ltuzd.telematik-test/kon8/fm/vsdservice", (Object)ksd.getVsdService());
    }

    @ParameterizedTest
    @MethodSource
    void shouldReadSds(ConnectorServices connectorServices) {
        KonnektorServiceDefinition ksd = KonnektorServiceDefinition.from((ConnectorServices)connectorServices);
        Assertions.assertNotNull((Object)ksd);
        Assertions.assertNotNull((Object)ksd.getCardService());
        Assertions.assertNotNull((Object)ksd.getCertificateService());
        Assertions.assertNotNull((Object)ksd.getEventService());
        Assertions.assertNotNull((Object)ksd.getEncryptionService());
        Assertions.assertNotNull((Object)ksd.getCardTerminalService());
        Assertions.assertNotNull((Object)ksd.getAuthSignatureService());
        Assertions.assertNotNull((Object)ksd.getSignatureService());
        Assertions.assertNotNull((Object)ksd.getVsdService());
    }

    @Test
    void shouldCreateForSoftKon() {
        KonnektorServiceDefinition ksd = KonnektorServiceDefinition.forSoftKon();
        Assertions.assertNotNull((Object)ksd);
        Assertions.assertNotNull((Object)ksd.getCardService());
        Assertions.assertNotNull((Object)ksd.getCertificateService());
        Assertions.assertNotNull((Object)ksd.getEventService());
        Assertions.assertNotNull((Object)ksd.getEncryptionService());
        Assertions.assertNotNull((Object)ksd.getCardTerminalService());
        Assertions.assertNotNull((Object)ksd.getAuthSignatureService());
        Assertions.assertNotNull((Object)ksd.getSignatureService());
        Assertions.assertNotNull((Object)ksd.getVsdService());
    }
}

