/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation.utils;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import java.text.MessageFormat;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.junit.jupiter.api.BeforeEach;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FhirValidatingTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FhirValidatingTest.class);
    protected ValidatorFhir fhirValidator;

    @BeforeEach
    void beforeEach() throws InitializationError {
        this.initialize();
        if (this.fhirValidator == null) {
            throw new InitializationError("FhirValidator was not set during initialization");
        }
    }

    protected abstract void initialize();

    protected final void printValidationResult(ValidationResult result) {
        this.printValidationResult(result, m -> !m.getSeverity().equals((Object)ResultSeverityEnum.INFORMATION));
    }

    protected final void printValidationResult(ValidationResult result, Predicate<SingleValidationMessage> messageFilter) {
        if (!result.isSuccessful()) {
            String r = result.getMessages().stream().filter(messageFilter).map(m -> MessageFormat.format("[{0} in Line {3} at {1}]: {2}", m.getSeverity(), m.getLocationString(), m.getMessage(), m.getLocationLine())).collect(Collectors.joining("\n\t"));
            log.warn("--- Found Validation Messages after validation: {} ---\n\t{}\n------", (Object)result.getMessages().stream().filter(messageFilter).count(), (Object)r);
        }
    }
}

