/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation.support;

import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationContext;
import de.gematik.bbriccs.fhir.validation.support.ErrorMessageFilter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class ErrorMessageFilterTest {
    ErrorMessageFilterTest() {
    }

    private IValidationContext<IBaseResource> createValidationContextMock(List<String> messages) {
        IValidationContext mock = (IValidationContext)Mockito.mock(ValidationContext.class);
        List validationMessages = messages.stream().map(m -> {
            SingleValidationMessage svm = new SingleValidationMessage();
            svm.setMessage(m);
            svm.setSeverity(ResultSeverityEnum.WARNING);
            return svm;
        }).collect(Collectors.toList());
        Mockito.when((Object)mock.getMessages()).thenReturn(validationMessages);
        return mock;
    }

    @ParameterizedTest
    @MethodSource
    void shouldFilterFhirCommentsByDefault(List<String> filters) {
        ErrorMessageFilter emf = new ErrorMessageFilter(filters);
        List<String> messages = List.of("something went badly wrong!", "Unrecognised property '@fhir_comments' in your resource");
        IValidationContext<IBaseResource> vctx = this.createValidationContextMock(messages);
        Assertions.assertEquals((int)2, (int)vctx.getMessages().size());
        emf.validateResource(vctx);
        Assertions.assertEquals((int)1, (int)vctx.getMessages().size());
    }

    static Stream<Arguments> shouldFilterFhirCommentsByDefault() {
        return Stream.of(Arguments.of((Object[])new Object[]{List.of()}), null);
    }

    @Test
    void shouldFilterWithCustomMessages() {
        ErrorMessageFilter emf = new ErrorMessageFilter(List.of("^something went badly wrong.*"));
        List<String> messages = List.of("something went badly wrong in your resources of Type Bundle xyz", "Unrecognised property '@fhir_comments' in your resource");
        IValidationContext<IBaseResource> vctx = this.createValidationContextMock(messages);
        Assertions.assertEquals((int)2, (int)vctx.getMessages().size());
        emf.validateResource(vctx);
        Assertions.assertEquals((int)0, (int)vctx.getMessages().size());
    }
}

