/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import de.gematik.bbriccs.fhir.validation.support.CodeSystemFilter;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CodeSystemFilterTest {
    CodeSystemFilterTest() {
    }

    @Test
    void shouldNotSupportNullCodeSystems() {
        CodeSystemFilter filter = new CodeSystemFilter(FhirContext.forR4(), List.of());
        ValidationSupportContext vsc = (ValidationSupportContext)Mockito.mock(ValidationSupportContext.class);
        Assertions.assertFalse((boolean)filter.isCodeSystemSupported(vsc, null));
    }

    @Test
    void shouldNotValidateNullCodeSystem() {
        CodeSystemFilter filter = new CodeSystemFilter(FhirContext.forR4(), List.of());
        ValidationSupportContext vsc = (ValidationSupportContext)Mockito.mock(ValidationSupportContext.class);
        ConceptValidationOptions cvo = (ConceptValidationOptions)Mockito.mock(ConceptValidationOptions.class);
        IValidationSupport.CodeValidationResult result = filter.validateCode(vsc, cvo, null, "CODE", "display", "https://valueset.com");
        Assertions.assertNull((Object)result);
    }
}

