/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.conf.ProfilesConfigurator;
import de.gematik.bbriccs.fhir.validation.ProfiledValidator;
import de.gematik.bbriccs.fhir.validation.ReferenzValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.ValidatorFhirFactory;
import de.gematik.bbriccs.fhir.validation.utils.FhirValidatingTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.refv.SupportedValidationModule;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ValidatorFhirTest
extends FhirValidatingTest {
    private static ValidatorFhir validator;

    ValidatorFhirTest() {
    }

    @BeforeAll
    static void setup() {
        validator = ValidatorFhirFactory.createValidator();
    }

    static Stream<Arguments> shouldValidateValidErpFhirResources() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldValidateValidErpFhirResourcesWithRefValidator() {
        Stream<File> dav = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/dav/1.2", (boolean)true).stream().filter(f -> f.getName().endsWith(".xml"));
        Stream<File> kbv = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0", (boolean)true).stream().filter(f -> f.getName().endsWith(".xml"));
        return Stream.concat(dav, kbv).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldValidateWithSingleProfileValidatorWithoutSupport() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/hl7", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldValidateValidErpResourcesWithoutCanonicalClaims() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldValidateErpCommunications() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/erx/1.2.0/communication", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldDetectInvalidFhirResources() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/invalid", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @Override
    protected void initialize() {
        this.fhirValidator = validator;
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldFailOnValidateGarbage(String content) {
        ValidationResult vr = (ValidationResult)Assertions.assertDoesNotThrow(() -> this.fhirValidator.validate(content));
        Assertions.assertFalse((boolean)vr.isSuccessful());
        Assertions.assertFalse((boolean)vr.getMessages().isEmpty());
        ResultSeverityEnum severity = ((SingleValidationMessage)vr.getMessages().get(0)).getSeverity();
        MatcherAssert.assertThat((Object)severity, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)ResultSeverityEnum.ERROR), (Matcher)CoreMatchers.is((Object)ResultSeverityEnum.FATAL)));
    }

    static Stream<Arguments> shouldFailOnValidateGarbage() {
        return Stream.of("Garbage content is definitely no valid FHIR content", "<xml>invalid</xml>", "{content: \"invalid\"}", "{\"content}\": \"invalid\"}", "").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldValidateValidErpFhirResources(File file) {
        String content = ResourceLoader.readString((File)file);
        ValidationResult vr = this.fhirValidator.validate(content);
        this.printValidationResult(vr);
        Assertions.assertTrue((boolean)vr.isSuccessful(), () -> MessageFormat.format("Given FHIR-Resource from {0} is invalid", file.getName()));
    }

    @ParameterizedTest
    @MethodSource
    void shouldValidateValidErpFhirResourcesWithRefValidator(File file) {
        String content = ResourceLoader.readString((File)file);
        ValidatorFhir refValidator = ReferenzValidator.withValidationModule((SupportedValidationModule)SupportedValidationModule.ERP);
        ValidationResult vr = refValidator.validate(content);
        this.printValidationResult(vr);
        Assertions.assertTrue((boolean)vr.isSuccessful(), () -> MessageFormat.format("Given FHIR-Resource from {0} is invalid", file.getName()));
    }

    @ParameterizedTest
    @MethodSource
    void shouldValidateWithSingleProfileValidatorWithoutSupport(File file) {
        String content = ResourceLoader.readString((File)file);
        ProfiledValidator validator = new ProfiledValidator("test_validator", List.of());
        ValidationResult vr = validator.validate(content);
        this.printValidationResult(vr);
        Assertions.assertTrue((boolean)vr.isSuccessful());
        Assertions.assertNotNull((Object)validator.getContext());
    }

    @ParameterizedTest
    @MethodSource
    void shouldValidateValidErpResourcesWithoutCanonicalClaims(File file) {
        String content = ResourceLoader.readString((File)file);
        FhirContext ctx = FhirContext.forR4();
        List profileSettings = ProfilesConfigurator.getDefaultConfiguration().getProfileConfigurations();
        profileSettings.forEach(psdto -> psdto.getProfiles().forEach(pdto -> pdto.setCanonicalClaims(List.of())));
        ValidatorFhir customValidator = ValidatorFhirFactory.createValidator((FhirContext)ctx, (List)profileSettings);
        ValidationResult vr = customValidator.validate(content);
        Assertions.assertTrue((boolean)vr.isSuccessful());
    }

    @ParameterizedTest
    @MethodSource
    void shouldValidateErpCommunications(File file) {
        String content = ResourceLoader.readString((File)file);
        ValidationResult vr = this.fhirValidator.validate(content);
        this.printValidationResult(vr);
        Assertions.assertTrue((boolean)vr.isSuccessful());
    }

    @ParameterizedTest
    @MethodSource
    void shouldDetectInvalidFhirResources(File file) {
        String content = ResourceLoader.readString((File)file);
        ValidationResult vr = this.fhirValidator.validate(content);
        Assertions.assertFalse((boolean)vr.isSuccessful());
    }
}

