/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.bbriccs.fhir.conf.ProfileSettingsDto;
import de.gematik.bbriccs.fhir.conf.exceptions.FhirConfigurationException;
import de.gematik.bbriccs.fhir.exceptions.UnsupportedEncodingException;
import de.gematik.bbriccs.fhir.validation.ProfiledValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.ValidatorFhirFactory;
import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ValidatorFhirFactoryTest {
    ValidatorFhirFactoryTest() {
    }

    @Test
    void shouldNotInstantiate() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(ValidatorFhirFactory.class));
    }

    @Test
    void shouldThrowOnEmptyConfiguration() {
        LinkedList configuredProfiles = new LinkedList();
        FhirContext ctx = FhirContext.forR4();
        Assertions.assertThrows(FhirConfigurationException.class, () -> ValidatorFhirFactory.createValidator((FhirContext)ctx, (List)configuredProfiles));
    }

    @Test
    void shouldThrowOnNullConfiguration() {
        FhirContext ctx = FhirContext.forR4();
        Assertions.assertThrows(FhirConfigurationException.class, () -> ValidatorFhirFactory.createValidator((FhirContext)ctx, null));
    }

    @Test
    void shouldThrowOnInvalidProfileFileExtensions() throws JsonProcessingException {
        String profilesConfig = ResourceLoader.readFileFromResource((String)"fhir/ihe-d_configuration_01.yaml");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        List configuredProfiles = (List)mapper.readValue(profilesConfig, (TypeReference)new TypeReference<List<ProfileSettingsDto>>(){});
        configuredProfiles.stream().flatMap(psd -> psd.getProfiles().stream()).forEach(p -> p.setOmitProfiles(List.of("invalid.json")));
        FhirContext ctx = FhirContext.forR4();
        UnsupportedEncodingException uee = (UnsupportedEncodingException)Assertions.assertThrows(UnsupportedEncodingException.class, () -> ValidatorFhirFactory.createValidator((FhirContext)ctx, (List)configuredProfiles));
        Assertions.assertTrue((boolean)uee.getMessage().contains("invalid.txt"));
    }

    @Test
    void shouldThrowOnInvalidProfileFile() throws JsonProcessingException {
        String profilesConfig = ResourceLoader.readFileFromResource((String)"fhir/ihe-d_configuration_01.yaml");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        List configuredProfiles = (List)mapper.readValue(profilesConfig, (TypeReference)new TypeReference<List<ProfileSettingsDto>>(){});
        configuredProfiles.stream().flatMap(psd -> psd.getProfiles().stream()).forEach(p -> p.setOmitProfiles(List.of("invalid.txt")));
        FhirContext ctx = FhirContext.forR4();
        FhirConfigurationException uee = (FhirConfigurationException)Assertions.assertThrows(FhirConfigurationException.class, () -> ValidatorFhirFactory.createValidator((FhirContext)ctx, (List)configuredProfiles));
        Assertions.assertTrue((boolean)uee.getMessage().contains("invalid.json"));
    }

    @Test
    void shouldNotThrowIfInvalidIsOmitted() throws JsonProcessingException {
        String profilesConfig = ResourceLoader.readFileFromResource((String)"fhir/ihe-d_configuration_02.yaml");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        List configuredProfiles = (List)mapper.readValue(profilesConfig, (TypeReference)new TypeReference<List<ProfileSettingsDto>>(){});
        FhirContext ctx = FhirContext.forR4();
        Assertions.assertDoesNotThrow(() -> ValidatorFhirFactory.createValidator((FhirContext)ctx, (List)configuredProfiles));
    }

    @Test
    void shouldChooseSingleProfileValidator() throws JsonProcessingException {
        String profilesConfig = ResourceLoader.readFileFromResource((String)"fhir/single_profile_configuration.yaml");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        List configuredProfiles = (List)mapper.readValue(profilesConfig, (TypeReference)new TypeReference<List<ProfileSettingsDto>>(){});
        ValidatorFhir validator = ValidatorFhirFactory.createValidator((FhirContext)FhirContext.forR4(), (List)configuredProfiles);
        Assertions.assertEquals(ProfiledValidator.class, validator.getClass());
    }
}

