/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.validation.ReferenzValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.utils.FhirValidatingTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.refv.SupportedValidationModule;
import de.gematik.refv.commons.exceptions.ValidationModuleInitializationException;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class ReferenzValidatorTest
extends FhirValidatingTest {
    private static final ValidatorFhir MY_VALIDATOR = ReferenzValidator.withValidationModule((SupportedValidationModule)SupportedValidationModule.ERP);

    ReferenzValidatorTest() {
    }

    @Override
    protected void initialize() {
        this.fhirValidator = MY_VALIDATOR;
    }

    @Test
    void shouldThrowOnInvalidConfiguration() {
        SupportedValidationModule svm = (SupportedValidationModule)Mockito.mock(SupportedValidationModule.class);
        Assertions.assertThrows(ValidationModuleInitializationException.class, () -> ReferenzValidator.withValidationModule((SupportedValidationModule)svm));
    }

    @Test
    void shouldValidateInvalidResources() {
        Bundle resource = new Bundle();
        Assertions.assertFalse((boolean)this.fhirValidator.isValid((IBaseResource)resource));
        ValidationResult vr = this.fhirValidator.validate((IBaseResource)resource);
        Assertions.assertFalse((boolean)vr.getMessages().isEmpty());
    }

    static Stream<Arguments> validErpResources() {
        List files = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv", (boolean)true);
        return files.stream().map(f -> Arguments.arguments((Object[])new Object[]{f.getAbsolutePath(), ResourceLoader.readString((File)f)}));
    }

    @ParameterizedTest(name="[{index}] Validate valid File ''{0}'' with ReferenzValidator")
    @MethodSource(value={"validErpResources"})
    void shouldValidateValidResource(String file, String content) {
        FhirContext ctx = this.fhirValidator.getContext();
        IParser parser = EncodingType.guessFromContent((String)content).chooseAppropriateParser(() -> ((FhirContext)ctx).newXmlParser(), () -> ((FhirContext)ctx).newJsonParser());
        IBaseResource resource = parser.parseResource(content);
        Assertions.assertTrue((boolean)this.fhirValidator.isValid(resource));
    }
}

