/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import de.gematik.bbriccs.fhir.validation.ProfileExtractor;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Configuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ProfileExtractorTest {
    private boolean doesAcceptInvalidEnums;
    private static ProfileExtractor profileExtractor;

    ProfileExtractorTest() {
    }

    @BeforeAll
    static void initExtractor() {
        profileExtractor = new ProfileExtractor();
    }

    @BeforeEach
    void setup() {
        this.doesAcceptInvalidEnums = Configuration.isAcceptInvalidEnums();
        Configuration.setAcceptInvalidEnums((boolean)false);
    }

    @AfterEach
    void teardown() {
        Configuration.setAcceptInvalidEnums((boolean)this.doesAcceptInvalidEnums);
    }

    @ParameterizedTest(name="Should not fail on missing profile/meta tags in searchsets on {0}")
    @ValueSource(strings={"examples/fhir/valid/erp/erx/1.2.0/chargeitembundle/a05a235a-a214-11ed-a8fc-0242ac120002.xml", "examples/fhir/valid/erp/erx/1.2.0/chargeitembundle/abc825bc-bc30-45f8-b109-1b343fff5c45.json", "examples/fhir/invalid/no_profiles_bundle.xml", "examples/fhir/invalid/no_metas_bundle.xml", "examples/fhir/invalid/no_profile_value_bundle.xml", "examples/fhir/invalid/invalid_bundle_type.xml", "examples/invalid/sample_01.xml"})
    void shouldNotFailOnNoProfilesInSearchsets(String filePath) {
        String content = ResourceLoader.readFileFromResource((String)filePath);
        Optional p = profileExtractor.extractProfile(content);
        Assertions.assertTrue((boolean)p.isEmpty());
    }

    @ParameterizedTest(name="Should not fail on missing profile/meta tags in collections on {0}")
    @ValueSource(strings={"examples/fhir/edgecases/empty_root_profile_collection.xml", "examples/fhir/edgecases/missing_root_profile_collection.xml"})
    void shouldFindProfileFromCollectionChildren(String filePath) {
        String content = ResourceLoader.readFileFromResource((String)filePath);
        Optional p = profileExtractor.extractProfile(content);
        Assertions.assertTrue((boolean)p.isPresent());
    }

    @Test
    void shouldExtractXmlProfiles() {
        List kbvBundleResources = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.0.2/bundle");
        String expectedProfile = "https://fhir.kbv.de/StructureDefinition/KBV_PR_ERP_Bundle|1.0.2";
        kbvBundleResources.forEach(file -> {
            String content = ResourceLoader.readString((File)file);
            Optional profile = profileExtractor.extractProfile(content);
            Assertions.assertEquals((Object)"https://fhir.kbv.de/StructureDefinition/KBV_PR_ERP_Bundle|1.0.2", profile.orElseThrow());
        });
    }

    @Test
    void shouldExtractJsonProfiles() {
        String filePath = "examples/fhir/valid/erp/erx/1.2.0/auditevent/9361863d-fec0-4ba9-8776-7905cf1b0cfa.json";
        String content = ResourceLoader.readFileFromResource((String)"examples/fhir/valid/erp/erx/1.2.0/auditevent/9361863d-fec0-4ba9-8776-7905cf1b0cfa.json");
        Optional profile = profileExtractor.extractProfile(content);
        String expectedProfile = "https://gematik.de/fhir/erp/StructureDefinition/GEM_ERP_PR_AuditEvent|1.2";
        Assertions.assertTrue((boolean)profile.isPresent());
        Assertions.assertEquals((Object)"https://gematik.de/fhir/erp/StructureDefinition/GEM_ERP_PR_AuditEvent|1.2", profile.orElseThrow());
    }

    @ParameterizedTest
    @ValueSource(strings={"<xml>", "alternative_json", ""})
    void shouldNotCrashOnCheckingSearchBundles(String content) {
        Assertions.assertFalse((boolean)profileExtractor.isUnprofiledSearchSet(content));
    }

    @ParameterizedTest
    @ValueSource(strings={"examples/fhir/valid/erp/erx/1.2.0/chargeitembundle/abc825bc-bc30-45f8-b109-1b343fff5c45.json", "examples/fhir/valid/erp/erx/1.2.0/chargeitembundle/ea33a992-a214-11ed-a8fc-0242ac120002.xml"})
    void shouldNonProfiledDetectSearchSets(String resourcePath) {
        String content = ResourceLoader.readFileFromResource((String)resourcePath);
        Assertions.assertTrue((boolean)profileExtractor.isUnprofiledSearchSet(content));
    }

    @ParameterizedTest
    @ValueSource(strings={"examples/fhir/valid/erp/dav/1.2/ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml", "examples/fhir/valid/erp/erx/1.2.0/receiptbundle/dffbfd6a-5712-4798-bdc8-07201eb77ab8.json", "examples/fhir/valid/erp/erx/1.2.0/receiptbundle/dffbfd6a-5712-4798-bdc8-07201eb77ab8.xml", "examples/fhir/valid/erp/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml", "examples/fhir/valid/erp/erx/1.2.0/auditevent/9361863d-fec0-4ba9-8776-7905cf1b0cfa.xml", "examples/fhir/valid/erp/erx/1.2.0/auditevent/9361863d-fec0-4ba9-8776-7905cf1b0cfa.json"})
    void shouldPassOtherResources(String resourcePath) {
        String content = ResourceLoader.readFileFromResource((String)resourcePath);
        Assertions.assertFalse((boolean)profileExtractor.isUnprofiledSearchSet(content));
    }
}

