/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.validation.NonProfiledValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.utils.FhirValidatingTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NonProfiledValidatorTest
extends FhirValidatingTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonProfiledValidatorTest.class);
    private static final ValidatorFhir MY_VALIDATOR = new NonProfiledValidator();

    NonProfiledValidatorTest() {
    }

    @Override
    protected void initialize() {
        this.fhirValidator = MY_VALIDATOR;
    }

    @ParameterizedTest(name="[{index}] Should not throw on invalid File ''{0}''")
    @MethodSource
    void shouldValidateInvalidResourceContents(String file, String content) {
        log.trace("Validate invalid file: {}", (Object)file);
        Assertions.assertFalse((boolean)this.fhirValidator.isValid(content));
    }

    static Stream<Arguments> shouldValidateInvalidResourceContents() {
        List files = ResourceLoader.getResourceFilesInDirectory((String)"examples/invalid", (boolean)true);
        return files.stream().map(f -> Arguments.arguments((Object[])new Object[]{f.getName(), ResourceLoader.readString((File)f)}));
    }

    @Test
    void shouldValidateInvalidResources() {
        Bundle resource = new Bundle();
        Assertions.assertFalse((boolean)this.fhirValidator.isValid((IBaseResource)resource));
        ValidationResult vr = this.fhirValidator.validate((IBaseResource)resource);
        Assertions.assertFalse((boolean)vr.getMessages().isEmpty());
    }

    @ParameterizedTest(name="[{index}] Should validate valid example {0}")
    @MethodSource
    void shouldValidateValidResources(String file, String content) {
        log.debug("Validate valid file: {}", (Object)file);
        Assertions.assertTrue((boolean)this.fhirValidator.isValid(content));
    }

    static Stream<Arguments> shouldValidateValidResources() {
        List files = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid", (boolean)true);
        return files.stream().map(f -> Arguments.arguments((Object[])new Object[]{f.getAbsolutePath(), ResourceLoader.readString((File)f)}));
    }

    @Test
    void shouldProvideFhirContext() {
        NonProfiledValidator validator = new NonProfiledValidator();
        Assertions.assertNotNull((Object)validator.getContext());
    }
}

