/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.ValidatorFhirFactory;
import de.gematik.bbriccs.fhir.validation.utils.FhirValidatingTest;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MultiProfileValidatorTest
extends FhirValidatingTest {
    private static final ValidatorFhir MY_VALIDATOR = ValidatorFhirFactory.createValidator((FhirContext)FhirContext.forR4());

    MultiProfileValidatorTest() {
    }

    static Stream<Arguments> validErpResources() {
        List files = ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp", (boolean)true);
        return files.stream().map(f -> Arguments.arguments((Object[])new Object[]{f.getName(), ResourceLoader.readString((File)f)}));
    }

    @Override
    protected void initialize() {
        this.fhirValidator = MY_VALIDATOR;
    }

    @ParameterizedTest(name="[{index}] Validate valid File ''{0}'' with Bbriccs-Validator")
    @MethodSource(value={"validErpResources"})
    void shouldValidateValidResourceContents(String file, String content) {
        FhirContext ctx = this.fhirValidator.getContext();
        IParser parser = EncodingType.guessFromContent((String)content).chooseAppropriateParser(() -> ((FhirContext)ctx).newXmlParser(), () -> ((FhirContext)ctx).newJsonParser()).setOmitResourceId(false).setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        IBaseResource resource = parser.parseResource(content);
        ValidationResult vr = this.fhirValidator.validate(resource);
        this.printValidationResult(vr);
        Assertions.assertTrue((boolean)vr.isSuccessful());
    }

    @Test
    void shouldFilterEmptyProfiles() {
        String content = ResourceLoader.readFileFromResource((String)"examples/fhir/valid/erp/erx/1.2.0/acceptbundle/cef4b960-7ce4-4755-b4ce-3b01a30ec2f0.xml");
        FhirContext ctx = this.fhirValidator.getContext();
        IParser parser = ctx.newXmlParser();
        Bundle bundle = (Bundle)parser.parseResource(Bundle.class, content);
        bundle.getMeta().setProfile(List.of(new CanonicalType("")));
        ValidationResult vr = this.fhirValidator.validate((IBaseResource)bundle);
        Assertions.assertTrue((boolean)vr.isSuccessful());
    }
}

