/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.validation.DummyValidator;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class DummyValidatorTest {
    DummyValidatorTest() {
    }

    static Stream<Arguments> invalidResources() {
        List files = ResourceLoader.getResourceFilesInDirectory((String)"examples/invalid", (boolean)true);
        return files.stream().map(f -> Arguments.arguments((Object[])new Object[]{f.getName(), ResourceLoader.readString((File)f)}));
    }

    @ParameterizedTest(name="[{index}] Validate invalid File ''{0}'' with DummyValidator")
    @MethodSource(value={"invalidResources"})
    void shouldValidateInvalidResourceContents(String file, String content) {
        DummyValidator validator = new DummyValidator(FhirContext.forR4());
        Assertions.assertTrue((boolean)validator.isValid(content));
        ValidationResult vr = validator.validate(content);
        Assertions.assertEquals((int)1, (int)vr.getMessages().size());
        Assertions.assertEquals((Object)ResultSeverityEnum.INFORMATION, (Object)((SingleValidationMessage)vr.getMessages().get(0)).getSeverity());
        Assertions.assertNotNull((Object)validator.getContext());
    }

    @Test
    void shouldValidateInvalidResources() {
        DummyValidator validator = new DummyValidator(FhirContext.forR4());
        Bundle resource = new Bundle();
        Assertions.assertTrue((boolean)validator.isValid((IBaseResource)resource));
        ValidationResult vr = validator.validate((IBaseResource)resource);
        Assertions.assertEquals((int)1, (int)vr.getMessages().size());
        Assertions.assertEquals((Object)ResultSeverityEnum.INFORMATION, (Object)((SingleValidationMessage)vr.getMessages().get(0)).getSeverity());
        Assertions.assertNotNull((Object)validator.getContext());
    }
}

