/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.ValidationResultHelper;
import de.gematik.bbriccs.fhir.exceptions.FhirValidationException;
import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.r4.model.Bundle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ValidationResultHelperTest {
    ValidationResultHelperTest() {
    }

    @Test
    void coverPrivateConstructor() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(ValidationResultHelper.class));
    }

    @Test
    void shouldThrowOnBaseInvalidResult() {
        ValidationResult vr = ValidationResultHelperTest.createFailingValidationResult();
        Assertions.assertThrows(FhirValidationException.class, () -> ValidationResultHelper.throwOnInvalidValidationResult((ValidationResult)vr));
    }

    @Test
    void shouldNotThrowOnBaseValidResult() {
        ValidationResult vr = ValidationResultHelperTest.createEmptyValidationResult();
        Assertions.assertDoesNotThrow(() -> ValidationResultHelper.throwOnInvalidValidationResult((ValidationResult)vr));
    }

    @Test
    void shouldThrowOnConcreteInvalidResult() {
        ValidationResult vr = ValidationResultHelperTest.createFailingValidationResult();
        Assertions.assertThrows(FhirValidationException.class, () -> ValidationResultHelper.throwOnInvalidValidationResult(Bundle.class, (ValidationResult)vr));
    }

    @Test
    void shouldThrowOnManyDifferentErrorMessages() {
        ValidationResult vr = ValidationResultHelperTest.createFailingValidationResultWithAllSeverities();
        FhirValidationException exception = (FhirValidationException)Assertions.assertThrows(FhirValidationException.class, () -> ValidationResultHelper.throwOnInvalidValidationResult(Bundle.class, (ValidationResult)vr));
        String message = exception.getMessage();
        Assertions.assertTrue((boolean)message.contains("1 errors"));
        Assertions.assertTrue((boolean)message.contains("1 warnings"));
    }

    @Test
    void shouldNotThrowOnConcreteValidResult() {
        ValidationResult vr = ValidationResultHelperTest.createEmptyValidationResult();
        Assertions.assertDoesNotThrow(() -> ValidationResultHelper.throwOnInvalidValidationResult(Bundle.class, (ValidationResult)vr));
    }

    private static ValidationResult createEmptyValidationResult() {
        ValidationResult vr = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)vr.isSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)vr.getMessages()).thenReturn(List.of());
        return vr;
    }

    private static ValidationResult createFailingValidationResult() {
        ValidationResult vr = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)vr.isSuccessful()).thenReturn((Object)false);
        SingleValidationMessage errorMessage = new SingleValidationMessage();
        errorMessage.setMessage("mock error message");
        errorMessage.setSeverity(ResultSeverityEnum.ERROR);
        Mockito.when((Object)vr.getMessages()).thenReturn(List.of(errorMessage));
        return vr;
    }

    private static ValidationResult createFailingValidationResultWithAllSeverities() {
        ValidationResult vr = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)vr.isSuccessful()).thenReturn((Object)false);
        List<SingleValidationMessage> errorMessages = Arrays.stream(ResultSeverityEnum.values).map(severity -> {
            SingleValidationMessage svm = new SingleValidationMessage();
            svm.setMessage(MessageFormat.format("mock {0} message", severity.getCode()));
            svm.setSeverity(severity);
            return svm;
        }).toList();
        Mockito.when((Object)vr.getMessages()).thenReturn(errorMessages);
        return vr;
    }
}

