/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir;

import ca.uhn.fhir.parser.IParser;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.exceptions.UnsupportedEncodingException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class EncodingTypeTest {
    EncodingTypeTest() {
    }

    @ParameterizedTest(name="[{index}] Should decide XML Encoding from input ''{0}''")
    @ValueSource(strings={"Xml", "XML", "some XML", "person_01.xml"})
    void chooseFromXmlString(String input) {
        Assertions.assertEquals((Object)EncodingType.XML, (Object)EncodingType.fromString((String)input));
    }

    @ParameterizedTest(name="[{index}] Should decide JSON Encoding from input ''{0}''")
    @ValueSource(strings={"Json", "JSON", "some JSON", "test.json"})
    void chooseFromJsonString(String input) {
        Assertions.assertEquals((Object)EncodingType.JSON, (Object)EncodingType.fromString((String)input));
    }

    @Test
    void toFileExtension() {
        Assertions.assertEquals((Object)"xml", (Object)EncodingType.XML.toFileExtension());
        Assertions.assertEquals((Object)"json", (Object)EncodingType.JSON.toFileExtension());
    }

    @Test
    void shouldChooseParser() {
        IParser xmlParser = (IParser)Mockito.mock(IParser.class);
        IParser jsonParser = (IParser)Mockito.mock(IParser.class);
        Assertions.assertEquals((Object)xmlParser, (Object)EncodingType.chooseAppropriateParser((String)"xml", (IParser)xmlParser, (IParser)jsonParser));
        Assertions.assertEquals((Object)jsonParser, (Object)EncodingType.chooseAppropriateParser((String)"json", (IParser)xmlParser, (IParser)jsonParser));
    }

    @ParameterizedTest(name="[{index}] Given content ''{0}'' is not a valid for encoding types")
    @ValueSource(strings={"Gson", "GSON", "some GSON", "test.gson", "HTML", "test.html"})
    void chooseThrowOnInvalid(String input) {
        UnsupportedEncodingException exception = (UnsupportedEncodingException)Assertions.assertThrows(UnsupportedEncodingException.class, () -> EncodingType.fromString((String)input));
        Assertions.assertTrue((boolean)exception.getMessage().contains("not supported or invalid"));
    }

    @Test
    void shouldFlipEncoding() {
        Assertions.assertEquals((Object)EncodingType.XML, (Object)EncodingType.JSON.flipEncoding());
        Assertions.assertEquals((Object)EncodingType.JSON, (Object)EncodingType.XML.flipEncoding());
    }

    @Test
    void shouldGuessXmlFromContent() {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        EncodingType type = EncodingType.guessFromContent((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Assertions.assertEquals((Object)EncodingType.XML, (Object)type);
    }

    @ParameterizedTest
    @ValueSource(strings={"{}", "something else"})
    void shouldGuessJsonOnAnyOther(String content) {
        EncodingType type = EncodingType.guessFromContent((String)content);
        Assertions.assertEquals((Object)EncodingType.JSON, (Object)type);
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "\t", "\n", "\r", "\r\n"})
    void shouldGuessXmlOnEmptyStrings(String content) {
        EncodingType type = EncodingType.guessFromContent((String)content);
        Assertions.assertEquals((Object)EncodingType.XML, (Object)type);
    }
}

