/*
 * Copyright 2024 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Getter;
import lombok.val;
import org.hl7.fhir.r4.model.UsageContext;

@Getter
public class UsageContextMutatorProvider implements FhirTypeMutatorProvider<UsageContext> {

  private final List<FuzzingMutator<UsageContext>> mutators;

  public UsageContextMutatorProvider() {
    this.mutators = createMutators();
  }

  private static List<FuzzingMutator<UsageContext>> createMutators() {
    val mutators = new LinkedList<FuzzingMutator<UsageContext>>();
    mutators.add((ctx, uc) -> ctx.fuzzIdElement(UsageContext.class, uc));
    mutators.add(
        (ctx, uc) ->
            ctx.fuzzChildTypes(
                UsageContext.class, ensureNotNull(ctx.randomness(), uc).getExtension()));
    mutators.add(
        (ctx, uc) ->
            ctx.fuzzChild(UsageContext.class, ensureNotNull(ctx.randomness(), uc).getCode()));

    mutators.add(
        (ctx, uc) ->
            ctx.fuzzChild(UsageContext.class, ensureNotNull(ctx.randomness(), uc).getValue()));

    return mutators;
  }

  private static UsageContext ensureNotNull(Randomness randomness, UsageContext usageContext) {
    if (usageContext == null) {
      usageContext = randomness.fhir().createType(UsageContext.class);
    }

    return usageContext;
  }
}
