/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.rnd;

import de.gematik.bbriccs.fhir.builder.FakerBrick;
import de.gematik.bbriccs.fhir.fuzzing.FhirRandomness;
import de.gematik.bbriccs.fhir.fuzzing.ProbabilityDice;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.exceptions.FuzzerException;
import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.FhirRandomnessImpl;
import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.ProbabilityDiceImpl;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;

public class RandomnessImpl
implements Randomness {
    private final Random rnd;
    private final FakerBrick faker;
    private final ProbabilityDice pdIdTypes;
    private final ProbabilityDice pdMutator;
    private final ProbabilityDice pdChildResources;
    private final FhirRandomness fhir;

    public RandomnessImpl(Random rnd, ProbabilityDice pdMutator, ProbabilityDice pdChildResources) {
        this.rnd = rnd;
        this.pdIdTypes = new ProbabilityDiceImpl(rnd, 0.3);
        this.pdMutator = pdMutator;
        this.pdChildResources = pdChildResources;
        this.faker = new FakerBrick(new Locale("de"), rnd);
        this.fhir = new FhirRandomnessImpl(this);
    }

    @Override
    public FhirRandomness fhir() {
        return this.fhir;
    }

    @Override
    public ProbabilityDice idDice() {
        return this.pdIdTypes;
    }

    @Override
    public ProbabilityDice mutatorDice() {
        return this.pdMutator;
    }

    @Override
    public ProbabilityDice childResourceDice() {
        return this.pdChildResources;
    }

    @Override
    public <T> T chooseRandomElement(List<T> elements) {
        return this.chooseRandomly(elements).orElseThrow(() -> new FuzzerException("Impossible to pick random element from empty list"));
    }

    @Override
    public <T> Optional<T> chooseRandomly(List<T> elements) {
        if (elements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.faker.randomElement(elements));
    }

    @Override
    public <E extends Enum<?>> E chooseRandomFromEnum(Class<E> enumeration) {
        return (E)this.faker.randomEnum(enumeration);
    }

    @Override
    public <E extends Enum<?>> E chooseRandomFromEnum(Class<E> enumeration, E exclude) {
        if (exclude != null) {
            return (E)this.faker.randomEnum(enumeration, exclude);
        }
        return (E)this.faker.randomEnum(enumeration);
    }

    @Override
    public <E extends Enum<?>> E chooseRandomFromEnum(Class<E> enumeration, List<E> exclude) {
        return (E)this.faker.randomEnum(enumeration, exclude);
    }

    @Override
    public Random source() {
        return this.rnd;
    }

    @Override
    public String url() {
        String scheme = this.chooseRandomElement(List.of("http://", "https://"));
        return scheme + this.faker.internet().url();
    }

    @Override
    public String url(Object ... path) {
        StringBuilder ub = new StringBuilder(this.url());
        Arrays.stream(path).forEach(p -> ub.append(MessageFormat.format("/{0}", p)));
        return ub.toString();
    }

    @Override
    public String uuid() {
        return this.faker.internet().uuid();
    }

    @Override
    public String regexify(String regex) {
        return this.faker.regexify(regex);
    }

    @Override
    public String version() {
        return this.faker.app().version();
    }

    @Override
    public Date date() {
        Date maxDate = new GregorianCalendar(9999, 11, 31).getTime();
        return this.faker.date().between(new Date(0L), maxDate);
    }

    @Override
    public LocalTime time() {
        return LocalDateTime.ofInstant(this.date().toInstant(), ZoneId.systemDefault()).toLocalTime();
    }
}

