/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.rnd;

import de.gematik.bbriccs.fhir.fuzzing.ProbabilityDice;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class ProbabilityDiceImpl
implements ProbabilityDice {
    private final Random rnd;
    private final double probability;

    public ProbabilityDiceImpl(Random rnd, double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException(MessageFormat.format("Probability must be in range of 0.0 .. 1.0 but was given {0}", probability));
        }
        this.probability = probability;
        this.rnd = rnd;
    }

    @Override
    public boolean toss() {
        return (double)this.rnd.nextFloat() <= this.probability;
    }

    @Override
    public <T> List<T> chooseRandomElements(List<T> elements) {
        List ret = elements.stream().filter(tf -> this.toss()).collect(Collectors.toList());
        Collections.shuffle(ret, this.rnd);
        return ret;
    }
}

