/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.rnd;

import de.gematik.bbriccs.fhir.fuzzing.FhirRandomness;
import de.gematik.bbriccs.fhir.fuzzing.FhirType;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.text.MessageFormat;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceFactory;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Type;

public class FhirRandomnessImpl
implements FhirRandomness {
    private final Randomness randomness;

    public FhirRandomnessImpl(Randomness randomness) {
        this.randomness = randomness;
    }

    @Override
    public Resource createResource() {
        return this.createResource(this.randomness.chooseRandomFromEnum(ResourceType.class));
    }

    @Override
    public Resource createResource(ResourceType type) {
        return ResourceFactory.createResource((String)type.name());
    }

    @Override
    public Type createType() {
        return this.createType(this.randomness.chooseRandomFromEnum(FhirType.class));
    }

    @Override
    public Type createType(FhirType type) {
        return (Type)ResourceFactory.createType((String)type.getTypeName());
    }

    @Override
    public <T extends Type> T createType(Class<T> type) {
        return (T)this.createType(FhirType.fromClass(type));
    }

    @Override
    public String fhirResourceId() {
        return this.fhirResourceId(this.randomness.chooseRandomFromEnum(ResourceType.class));
    }

    @Override
    public String fhirResourceId(ResourceType resourceType) {
        return MessageFormat.format("{0}/{1}", resourceType.name(), this.randomness.uuid());
    }
}

