/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.UsageContext;

public class UsageContextMutatorProvider
implements FhirTypeMutatorProvider<UsageContext> {
    private final List<FuzzingMutator<UsageContext>> mutators = UsageContextMutatorProvider.createMutators();

    private static List<FuzzingMutator<UsageContext>> createMutators() {
        LinkedList<FuzzingMutator<UsageContext>> mutators = new LinkedList<FuzzingMutator<UsageContext>>();
        mutators.add((ctx, uc) -> ctx.fuzzIdElement(UsageContext.class, uc));
        mutators.add((ctx, uc) -> ctx.fuzzChildTypes(UsageContext.class, UsageContextMutatorProvider.ensureNotNull(ctx.randomness(), uc).getExtension()));
        mutators.add((ctx, uc) -> ctx.fuzzChild(UsageContext.class, UsageContextMutatorProvider.ensureNotNull(ctx.randomness(), uc).getCode()));
        mutators.add((ctx, uc) -> ctx.fuzzChild(UsageContext.class, UsageContextMutatorProvider.ensureNotNull(ctx.randomness(), uc).getValue()));
        return mutators;
    }

    private static UsageContext ensureNotNull(Randomness randomness, UsageContext usageContext) {
        if (usageContext == null) {
            usageContext = randomness.fhir().createType(UsageContext.class);
        }
        return usageContext;
    }

    @Override
    @Generated
    public List<FuzzingMutator<UsageContext>> getMutators() {
        return this.mutators;
    }
}

