/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.UriType;

public class UriTypeMutatorProvider
implements FhirTypeMutatorProvider<UriType> {
    private final List<FuzzingMutator<UriType>> mutators = UriTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<UriType>> createMutators() {
        LinkedList<FuzzingMutator<UriType>> mutators = new LinkedList<FuzzingMutator<UriType>>();
        mutators.add((ctx, uriType) -> ctx.fuzzIdElement(UriType.class, uriType));
        mutators.add((ctx, uriType) -> ctx.fuzzChildTypes(UriType.class, UriTypeMutatorProvider.ensureNotNull(ctx.randomness(), uriType).getExtension()));
        mutators.add((ctx, uriType) -> {
            uriType = UriTypeMutatorProvider.ensureNotNull(ctx.randomness(), uriType);
            String value = (String)uriType.getValue();
            PrimitiveTypeFuzzingResponse<String> response = ctx.fuzzPrimitiveType(MessageFormat.format("Fuzz UriType value {0}", value), PrimitiveStringTypes.URI, value);
            uriType.setValue((Object)response.getFuzzedValue());
            return response.getLogEntry();
        });
        return mutators;
    }

    private static UriType ensureNotNull(Randomness randomness, UriType uriType) {
        if (uriType == null) {
            uriType = randomness.fhir().createType(UriType.class);
        }
        return uriType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<UriType>> getMutators() {
        return this.mutators;
    }
}

