/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.UnsignedIntType;

public class UnsignedIntTypeMutatorProvider
implements FhirTypeMutatorProvider<UnsignedIntType> {
    private final List<FuzzingMutator<UnsignedIntType>> mutators = UnsignedIntTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<UnsignedIntType>> createMutators() {
        LinkedList<FuzzingMutator<UnsignedIntType>> mutators = new LinkedList<FuzzingMutator<UnsignedIntType>>();
        mutators.add((ctx, uit) -> ctx.fuzzIdElement(UnsignedIntType.class, uit));
        mutators.add((ctx, uit) -> ctx.fuzzChildTypes(UnsignedIntType.class, UnsignedIntTypeMutatorProvider.ensureNotNull(ctx.randomness(), uit).getExtension()));
        mutators.add((ctx, uit) -> {
            uit = UnsignedIntTypeMutatorProvider.ensureNotNull(ctx.randomness(), uit);
            int value = (Integer)uit.getValue();
            int fValue = ctx.randomness().source().nextInt();
            uit.setValue((Object)fValue);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Integer value: {0} -> {1}", value, fValue));
        });
        return mutators;
    }

    private static UnsignedIntType ensureNotNull(Randomness randomness, UnsignedIntType uit) {
        if (uit == null) {
            uit = randomness.fhir().createType(UnsignedIntType.class);
        }
        if (uit.getValue() == null) {
            uit.setValue((Object)randomness.source().nextInt());
        }
        return uit;
    }

    @Override
    @Generated
    public List<FuzzingMutator<UnsignedIntType>> getMutators() {
        return this.mutators;
    }
}

