/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.TriggerDefinition;

public class TriggerDefinitionMutatorProvider
implements FhirTypeMutatorProvider<TriggerDefinition> {
    private final List<FuzzingMutator<TriggerDefinition>> mutators = TriggerDefinitionMutatorProvider.createMutators();

    private static List<FuzzingMutator<TriggerDefinition>> createMutators() {
        LinkedList<FuzzingMutator<TriggerDefinition>> mutators = new LinkedList<FuzzingMutator<TriggerDefinition>>();
        mutators.add((ctx, td) -> ctx.fuzzIdElement(TriggerDefinition.class, td));
        mutators.add((ctx, td) -> ctx.fuzzChildTypes(TriggerDefinition.class, TriggerDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), td).getExtension()));
        mutators.add((ctx, td) -> ctx.fuzzChild(TriggerDefinition.class, TriggerDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), td).getCondition()));
        mutators.add((ctx, td) -> ctx.fuzzChild(TriggerDefinition.class, TriggerDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), td).getNameElement()));
        mutators.add((ctx, td) -> ctx.fuzzChild(TriggerDefinition.class, TriggerDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), td).getTiming()));
        mutators.add((ctx, td) -> {
            td = TriggerDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), td);
            TriggerDefinition.TriggerType type = td.getType();
            TriggerDefinition.TriggerType ftype = ctx.randomness().chooseRandomFromEnum(TriggerDefinition.TriggerType.class, type);
            td.setType(ftype);
            return FuzzingLogEntry.operation(MessageFormat.format("Change TriggerType of {0}: {1} -> {2}", td.getId(), type, ftype));
        });
        return mutators;
    }

    private static TriggerDefinition ensureNotNull(Randomness randomness, TriggerDefinition td) {
        if (td == null) {
            td = randomness.fhir().createType(TriggerDefinition.class);
        }
        return td;
    }

    @Override
    @Generated
    public List<FuzzingMutator<TriggerDefinition>> getMutators() {
        return this.mutators;
    }
}

