/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirType;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;

public class TimingTypeMutatorProvider
implements FhirTypeMutatorProvider<Timing> {
    private final List<FuzzingMutator<Timing>> mutators = TimingTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Timing>> createMutators() {
        LinkedList<FuzzingMutator<Timing>> mutators = new LinkedList<FuzzingMutator<Timing>>();
        mutators.add((ctx, timing) -> ctx.fuzzIdElement(Timing.class, timing));
        mutators.add((ctx, timing) -> ctx.fuzzChildTypes(Timing.class, TimingTypeMutatorProvider.ensureNotNull(ctx.randomness(), timing).getExtension()));
        mutators.add((ctx, timing) -> ctx.fuzzChildTypes(Timing.class, TimingTypeMutatorProvider.ensureNotNull(ctx.randomness(), timing).getModifierExtension()));
        mutators.add((ctx, timing) -> ctx.fuzzChildTypes(Timing.class, TimingTypeMutatorProvider.ensureNotNull(ctx.randomness(), timing).getEvent()));
        mutators.add((ctx, timing) -> ctx.fuzzChild(Timing.class, TimingTypeMutatorProvider.ensureNotNull(ctx.randomness(), timing).getCode()));
        mutators.add((ctx, timing) -> {
            Timing.TimingRepeatComponent repeatComponent = TimingTypeMutatorProvider.getRepeatComponent(ctx.randomness(), timing);
            if (!repeatComponent.hasBounds()) {
                FhirType boundsType = ctx.randomness().chooseRandomElement(List.of(FhirType.DURATION, FhirType.PERIOD, FhirType.RANGE));
                Type bounds = ctx.randomness().fhir().createType(boundsType);
                repeatComponent.setBounds(bounds);
            }
            if (repeatComponent.hasBoundsDuration()) {
                return ctx.fuzzChild(repeatComponent.getClass(), repeatComponent.getBoundsDuration());
            }
            if (repeatComponent.hasBoundsPeriod()) {
                return ctx.fuzzChild(repeatComponent.getClass(), repeatComponent.getBoundsPeriod());
            }
            if (repeatComponent.hasBoundsRange()) {
                return ctx.fuzzChild(repeatComponent.getClass(), repeatComponent.getBoundsRange());
            }
            return FuzzingLogEntry.noop("Repeated Component does not have any Duration/Period/Range to fuzz");
        });
        mutators.add((ctx, timing) -> {
            Timing.TimingRepeatComponent repeatComponent = TimingTypeMutatorProvider.getRepeatComponent(ctx.randomness(), timing);
            return ctx.fuzzChild(repeatComponent.getClass(), repeatComponent.getCountElement());
        });
        mutators.add((ctx, timing) -> {
            Timing.TimingRepeatComponent repeatComponent = TimingTypeMutatorProvider.getRepeatComponent(ctx.randomness(), timing);
            return ctx.fuzzChild(repeatComponent.getClass(), repeatComponent.getCountMaxElement());
        });
        mutators.add((ctx, timing) -> {
            Timing.TimingRepeatComponent repeatComponent = TimingTypeMutatorProvider.getRepeatComponent(ctx.randomness(), timing);
            Timing.UnitsOfTime unit = repeatComponent.getDurationUnit();
            Timing.UnitsOfTime funit = ctx.randomness().chooseRandomFromEnum(Timing.UnitsOfTime.class, unit);
            repeatComponent.setDurationUnit(funit);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Duration Unit: {0} -> {1}", unit, funit));
        });
        mutators.add((ctx, timing) -> {
            Timing.TimingRepeatComponent repeatComponent = TimingTypeMutatorProvider.getRepeatComponent(ctx.randomness(), timing);
            Timing.UnitsOfTime unit = repeatComponent.getPeriodUnit();
            Timing.UnitsOfTime funit = ctx.randomness().chooseRandomFromEnum(Timing.UnitsOfTime.class, unit);
            repeatComponent.setPeriodUnit(funit);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Period Unit: {0} -> {1}", unit, funit));
        });
        return mutators;
    }

    private static Timing ensureNotNull(Randomness randomness, Timing timing) {
        if (timing == null) {
            timing = randomness.fhir().createType(Timing.class);
        }
        return timing;
    }

    private static Timing.TimingRepeatComponent getRepeatComponent(Randomness randomness, Timing timing) {
        if (!(timing = TimingTypeMutatorProvider.ensureNotNull(randomness, timing)).hasRepeat()) {
            timing.setRepeat(new Timing.TimingRepeatComponent());
        }
        return timing.getRepeat();
    }

    @Override
    @Generated
    public List<FuzzingMutator<Timing>> getMutators() {
        return this.mutators;
    }
}

