/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.TimeType;

public class TimeTypeMutatorProvider
implements FhirTypeMutatorProvider<TimeType> {
    private final List<FuzzingMutator<TimeType>> mutators = TimeTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<TimeType>> createMutators() {
        LinkedList<FuzzingMutator<TimeType>> mutators = new LinkedList<FuzzingMutator<TimeType>>();
        mutators.add((ctx, timeType) -> ctx.fuzzIdElement(TimeType.class, timeType));
        mutators.add((ctx, timeType) -> ctx.fuzzChildTypes(TimeType.class, TimeTypeMutatorProvider.ensureNotNull(ctx.randomness(), timeType).getExtension()));
        mutators.add((ctx, timeType) -> {
            timeType = TimeTypeMutatorProvider.ensureNotNull(ctx.randomness(), timeType);
            LocalTime time = ctx.randomness().time();
            TemporalPrecisionEnum precision = ctx.randomness().chooseRandomFromEnum(TemporalPrecisionEnum.class, List.of(TemporalPrecisionEnum.YEAR, TemporalPrecisionEnum.MONTH, TemporalPrecisionEnum.DAY));
            timeType.setValue((Object)time.format(DateTimeFormatter.ofPattern("HH:mm:ss.SSSS")));
            timeType.setPrecision(precision);
            return FuzzingLogEntry.operation(MessageFormat.format("Change TimeType to {0}", timeType.getValueAsString()));
        });
        return mutators;
    }

    private static TimeType ensureNotNull(Randomness randomness, TimeType timeType) {
        if (timeType == null) {
            TemporalPrecisionEnum precision = randomness.chooseRandomFromEnum(TemporalPrecisionEnum.class, List.of(TemporalPrecisionEnum.YEAR, TemporalPrecisionEnum.MONTH, TemporalPrecisionEnum.DAY));
            timeType = randomness.fhir().createType(TimeType.class);
            timeType.setValue((Object)randomness.time().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSSS")));
            timeType.setPrecision(precision);
        }
        return timeType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<TimeType>> getMutators() {
        return this.mutators;
    }
}

