/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.SubstanceAmount;

public class SubstanceAmountMutatorProvider
implements FhirTypeMutatorProvider<SubstanceAmount> {
    private final List<FuzzingMutator<SubstanceAmount>> mutators = SubstanceAmountMutatorProvider.createMutators();

    private static List<FuzzingMutator<SubstanceAmount>> createMutators() {
        LinkedList<FuzzingMutator<SubstanceAmount>> mutators = new LinkedList<FuzzingMutator<SubstanceAmount>>();
        mutators.add((ctx, sa) -> ctx.fuzzIdElement(SubstanceAmount.class, sa));
        mutators.add((ctx, sa) -> ctx.fuzzChildTypes(SubstanceAmount.class, SubstanceAmountMutatorProvider.ensureNotNull(ctx.randomness(), sa).getExtension()));
        mutators.add((ctx, sa) -> ctx.fuzzChildTypes(SubstanceAmount.class, SubstanceAmountMutatorProvider.ensureNotNull(ctx.randomness(), sa).getModifierExtension()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SubstanceAmount.class, SubstanceAmountMutatorProvider.ensureNotNull(ctx.randomness(), sa).getAmountType()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SubstanceAmount.class, SubstanceAmountMutatorProvider.ensureNotNull(ctx.randomness(), sa).getAmount()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SubstanceAmount.class, SubstanceAmountMutatorProvider.ensureNotNull(ctx.randomness(), sa).getAmountTextElement()));
        mutators.add((ctx, sa) -> {
            sa = SubstanceAmountMutatorProvider.ensureNotNull(ctx.randomness(), sa);
            SubstanceAmount.SubstanceAmountReferenceRangeComponent refRange = sa.getReferenceRange();
            FuzzingLogEntry lowLimit = ctx.fuzzChild(sa.getClass(), refRange.getLowLimit());
            FuzzingLogEntry highLimit = ctx.fuzzChild(sa.getClass(), refRange.getHighLimit());
            return FuzzingLogEntry.parent(MessageFormat.format("Fuzz Low/High Limits of SubstanceAmount {0}", sa.getId()), List.of(lowLimit, highLimit));
        });
        return mutators;
    }

    private static SubstanceAmount ensureNotNull(Randomness randomness, SubstanceAmount sa) {
        if (sa == null) {
            sa = randomness.fhir().createType(SubstanceAmount.class);
        }
        return sa;
    }

    @Override
    @Generated
    public List<FuzzingMutator<SubstanceAmount>> getMutators() {
        return this.mutators;
    }
}

