/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.StringType;

public class StringTypeMutatorProvider
implements FhirTypeMutatorProvider<StringType> {
    private final List<FuzzingMutator<StringType>> mutators = StringTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<StringType>> createMutators() {
        LinkedList<FuzzingMutator<StringType>> mutators = new LinkedList<FuzzingMutator<StringType>>();
        mutators.add((ctx, stringType) -> ctx.fuzzIdElement(StringType.class, stringType));
        mutators.add((ctx, stringType) -> ctx.fuzzChildTypes(StringType.class, StringTypeMutatorProvider.ensureNotNull(ctx.randomness(), stringType).getExtension()));
        mutators.add((ctx, stringType) -> {
            stringType = StringTypeMutatorProvider.ensureNotNull(ctx.randomness(), stringType);
            String value = stringType.getValueNotNull();
            PrimitiveTypeFuzzingResponse<String> response = ctx.fuzzPrimitiveType(MessageFormat.format("Fuzz StringType value {0}", value), PrimitiveStringTypes.TEXT, value);
            stringType.setValue((Object)response.getFuzzedValue());
            return response.getLogEntry();
        });
        return mutators;
    }

    private static StringType ensureNotNull(Randomness randomness, StringType stringType) {
        if (stringType == null) {
            stringType = randomness.fhir().createType(StringType.class);
        }
        return stringType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<StringType>> getMutators() {
        return this.mutators;
    }
}

