/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Signature;

public class SignatureMutatorProvider
implements FhirTypeMutatorProvider<Signature> {
    private final List<FuzzingMutator<Signature>> mutators = SignatureMutatorProvider.createMutators();

    private static List<FuzzingMutator<Signature>> createMutators() {
        LinkedList<FuzzingMutator<Signature>> mutators = new LinkedList<FuzzingMutator<Signature>>();
        mutators.add((ctx, signature) -> ctx.fuzzIdElement(Signature.class, signature));
        mutators.add((ctx, signature) -> ctx.fuzzChildTypes(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getExtension()));
        mutators.add((ctx, signature) -> ctx.fuzzChildTypes(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getType()));
        mutators.add((ctx, signature) -> ctx.fuzzChild(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getSigFormatElement()));
        mutators.add((ctx, signature) -> ctx.fuzzChild(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getTargetFormatElement()));
        mutators.add((ctx, signature) -> ctx.fuzzChild(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getWhenElement()));
        mutators.add((ctx, signature) -> ctx.fuzzChild(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getWho()));
        mutators.add((ctx, signature) -> ctx.fuzzChild(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getOnBehalfOf()));
        mutators.add((ctx, signature) -> ctx.fuzzChild(Signature.class, SignatureMutatorProvider.ensureNotNull(ctx.randomness(), signature).getDataElement()));
        return mutators;
    }

    private static Signature ensureNotNull(Randomness randomness, Signature signature) {
        if (signature == null) {
            signature = randomness.fhir().createType(Signature.class);
        }
        return signature;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Signature>> getMutators() {
        return this.mutators;
    }
}

