/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.SampledData;

public class SampleDataMutatorProvider
implements FhirTypeMutatorProvider<SampledData> {
    private final List<FuzzingMutator<SampledData>> mutators = SampleDataMutatorProvider.createMutators();

    private static List<FuzzingMutator<SampledData>> createMutators() {
        LinkedList<FuzzingMutator<SampledData>> mutators = new LinkedList<FuzzingMutator<SampledData>>();
        mutators.add((ctx, sa) -> ctx.fuzzIdElement(SampledData.class, sa));
        mutators.add((ctx, sa) -> ctx.fuzzChildTypes(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getExtension()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getDataElement()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getDimensionsElement()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getFactorElement()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getLowerLimitElement()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getUpperLimitElement()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getOrigin()));
        mutators.add((ctx, sa) -> ctx.fuzzChild(SampledData.class, SampleDataMutatorProvider.ensureNotNull(ctx.randomness(), sa).getPeriodElement()));
        return mutators;
    }

    private static SampledData ensureNotNull(Randomness randomness, SampledData sa) {
        if (sa == null) {
            sa = randomness.fhir().createType(SampledData.class);
        }
        return sa;
    }

    @Override
    @Generated
    public List<FuzzingMutator<SampledData>> getMutators() {
        return this.mutators;
    }
}

