/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;

public class ReferenceTypeMutatorProvider
implements FhirTypeMutatorProvider<Reference> {
    private final List<FuzzingMutator<Reference>> mutators = ReferenceTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Reference>> createMutators() {
        LinkedList<FuzzingMutator<Reference>> mutators = new LinkedList<FuzzingMutator<Reference>>();
        mutators.add((ctx, reference) -> ctx.fuzzIdElement(Reference.class, reference));
        mutators.add((ctx, reference) -> ctx.fuzzChild(Reference.class, ReferenceTypeMutatorProvider.ensureNotNull(ctx.randomness(), reference).getTypeElement()));
        mutators.add((ctx, reference) -> ctx.fuzzChild(Reference.class, ReferenceTypeMutatorProvider.ensureNotNull(ctx.randomness(), reference).getDisplayElement()));
        mutators.add((ctx, reference) -> ctx.fuzzChild(Reference.class, ReferenceTypeMutatorProvider.ensureNotNull(ctx.randomness(), reference).getReferenceElement_()));
        mutators.add((ctx, reference) -> ctx.fuzzChild(Reference.class, ReferenceTypeMutatorProvider.ensureNotNull(ctx.randomness(), reference).getIdentifier()));
        mutators.add((ctx, reference) -> ctx.fuzzChildTypes(Reference.class, ReferenceTypeMutatorProvider.ensureNotNull(ctx.randomness(), reference).getExtension()));
        mutators.add((ctx, reference) -> {
            String fidv;
            String[] oidvTokens;
            reference = ReferenceTypeMutatorProvider.ensureNotNull(ctx.randomness(), reference);
            String oidv = reference.getReference();
            String[] stringArray = oidvTokens = oidv != null ? oidv.split("/") : ctx.randomness().fhir().fhirResourceId().split("/");
            if (oidvTokens.length == 2) {
                if (ctx.randomness().source().nextBoolean()) {
                    fidv = MessageFormat.format("{0}/{1}", oidvTokens[0], ctx.randomness().uuid());
                } else {
                    ResourceType rr = ctx.randomness().chooseRandomFromEnum(ResourceType.class);
                    fidv = MessageFormat.format("{0}/{1}", rr.toString(), oidvTokens[1]);
                }
            } else {
                fidv = UUID.randomUUID().toString();
            }
            reference.setReference(fidv);
            return FuzzingLogEntry.operation(MessageFormat.format("Replace Reference value: {0} -> {1}", oidv, fidv));
        });
        return mutators;
    }

    private static Reference ensureNotNull(Randomness randomness, Reference reference) {
        if (reference == null) {
            reference = randomness.fhir().createType(Reference.class);
        }
        return reference;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Reference>> getMutators() {
        return this.mutators;
    }
}

