/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Ratio;

public class RatioMutatorProvider
implements FhirTypeMutatorProvider<Ratio> {
    private final List<FuzzingMutator<Ratio>> mutators = RatioMutatorProvider.createMutators();

    private static List<FuzzingMutator<Ratio>> createMutators() {
        LinkedList<FuzzingMutator<Ratio>> mutators = new LinkedList<FuzzingMutator<Ratio>>();
        mutators.add((ctx, ratio) -> ctx.fuzzIdElement(Ratio.class, ratio));
        mutators.add((ctx, ratio) -> ctx.fuzzChildTypes(Ratio.class, RatioMutatorProvider.ensureNotNull(ctx.randomness(), ratio).getExtension()));
        mutators.add((ctx, ratio) -> ctx.fuzzChild(Ratio.class, RatioMutatorProvider.ensureNotNull(ctx.randomness(), ratio).getDenominator()));
        mutators.add((ctx, ratio) -> ctx.fuzzChild(Ratio.class, RatioMutatorProvider.ensureNotNull(ctx.randomness(), ratio).getNumerator()));
        return mutators;
    }

    private static Ratio ensureNotNull(Randomness randomness, Ratio ratio) {
        if (ratio == null) {
            ratio = randomness.fhir().createType(Ratio.class);
        }
        return ratio;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Ratio>> getMutators() {
        return this.mutators;
    }
}

