/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Range;

public class RangeMutatorProvider
implements FhirTypeMutatorProvider<Range> {
    private final List<FuzzingMutator<Range>> mutators = RangeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Range>> createMutators() {
        LinkedList<FuzzingMutator<Range>> mutators = new LinkedList<FuzzingMutator<Range>>();
        mutators.add((ctx, range) -> ctx.fuzzIdElement(Range.class, range));
        mutators.add((ctx, range) -> ctx.fuzzChildTypes(Range.class, RangeMutatorProvider.ensureNotNull(ctx.randomness(), range).getExtension()));
        mutators.add((ctx, range) -> ctx.fuzzChild(Range.class, RangeMutatorProvider.ensureNotNull(ctx.randomness(), range).getHigh()));
        mutators.add((ctx, range) -> ctx.fuzzChild(Range.class, RangeMutatorProvider.ensureNotNull(ctx.randomness(), range).getLow()));
        return mutators;
    }

    private static Range ensureNotNull(Randomness randomness, Range range) {
        if (range == null) {
            range = randomness.fhir().createType(Range.class);
        }
        return range;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Range>> getMutators() {
        return this.mutators;
    }
}

