/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Quantity;

public class QuantityMutatorProvider
implements FhirTypeMutatorProvider<Quantity> {
    private final List<FuzzingMutator<Quantity>> mutators = QuantityMutatorProvider.createMutators();

    private static List<FuzzingMutator<Quantity>> createMutators() {
        LinkedList<FuzzingMutator<Quantity>> mutators = new LinkedList<FuzzingMutator<Quantity>>();
        mutators.add((ctx, quantity) -> ctx.fuzzIdElement(Quantity.class, quantity));
        mutators.add((ctx, quantity) -> ctx.fuzzChildTypes(Quantity.class, QuantityMutatorProvider.ensureNotNull(ctx.randomness(), quantity).getExtension()));
        mutators.add((ctx, quantity) -> ctx.fuzzChild(Quantity.class, QuantityMutatorProvider.ensureNotNull(ctx.randomness(), quantity).getCodeElement()));
        mutators.add((ctx, quantity) -> ctx.fuzzChild(Quantity.class, QuantityMutatorProvider.ensureNotNull(ctx.randomness(), quantity).getSystemElement()));
        mutators.add((ctx, quantity) -> ctx.fuzzChild(Quantity.class, QuantityMutatorProvider.ensureNotNull(ctx.randomness(), quantity).getUnitElement()));
        mutators.add((ctx, quantity) -> ctx.fuzzChild(Quantity.class, QuantityMutatorProvider.ensureNotNull(ctx.randomness(), quantity).getValueElement()));
        mutators.add((ctx, quantity) -> {
            quantity = QuantityMutatorProvider.ensureNotNull(ctx.randomness(), quantity);
            Enumeration oqce = quantity.getComparatorElement();
            Quantity.QuantityComparator oqc = (Quantity.QuantityComparator)oqce.getValue();
            Quantity.QuantityComparator fqc = ctx.randomness().chooseRandomFromEnum(Quantity.QuantityComparator.class, oqc);
            oqce.setValue((Object)fqc);
            return FuzzingLogEntry.operation(MessageFormat.format("Change QuantityComparator: {0} -> {1}", oqc, fqc));
        });
        return mutators;
    }

    private static Quantity ensureNotNull(Randomness randomness, Quantity period) {
        if (period == null) {
            period = randomness.fhir().createType(Quantity.class);
        }
        return period;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Quantity>> getMutators() {
        return this.mutators;
    }
}

