/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.ProductShelfLife;

public class ProductShelfLifeMutatorProvider
implements FhirTypeMutatorProvider<ProductShelfLife> {
    private final List<FuzzingMutator<ProductShelfLife>> mutators = ProductShelfLifeMutatorProvider.createMutators();

    private static List<FuzzingMutator<ProductShelfLife>> createMutators() {
        LinkedList<FuzzingMutator<ProductShelfLife>> mutators = new LinkedList<FuzzingMutator<ProductShelfLife>>();
        mutators.add((ctx, psl) -> ctx.fuzzIdElement(ProductShelfLife.class, psl));
        mutators.add((ctx, psl) -> ctx.fuzzChildTypes(ProductShelfLife.class, ProductShelfLifeMutatorProvider.ensureNotNull(ctx.randomness(), psl).getExtension()));
        mutators.add((ctx, psl) -> ctx.fuzzChildTypes(ProductShelfLife.class, ProductShelfLifeMutatorProvider.ensureNotNull(ctx.randomness(), psl).getModifierExtension()));
        mutators.add((ctx, psl) -> ctx.fuzzChildTypes(ProductShelfLife.class, ProductShelfLifeMutatorProvider.ensureNotNull(ctx.randomness(), psl).getSpecialPrecautionsForStorage()));
        mutators.add((ctx, psl) -> ctx.fuzzChild(ProductShelfLife.class, ProductShelfLifeMutatorProvider.ensureNotNull(ctx.randomness(), psl).getType()));
        mutators.add((ctx, psl) -> ctx.fuzzChild(ProductShelfLife.class, ProductShelfLifeMutatorProvider.ensureNotNull(ctx.randomness(), psl).getIdentifier()));
        mutators.add((ctx, psl) -> ctx.fuzzChild(ProductShelfLife.class, ProductShelfLifeMutatorProvider.ensureNotNull(ctx.randomness(), psl).getPeriod()));
        return mutators;
    }

    private static ProductShelfLife ensureNotNull(Randomness randomness, ProductShelfLife psl) {
        if (psl == null) {
            psl = randomness.fhir().createType(ProductShelfLife.class);
        }
        return psl;
    }

    @Override
    @Generated
    public List<FuzzingMutator<ProductShelfLife>> getMutators() {
        return this.mutators;
    }
}

