/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.ProdCharacteristic;

public class ProdCharacteristicMutatorProvider
implements FhirTypeMutatorProvider<ProdCharacteristic> {
    private final List<FuzzingMutator<ProdCharacteristic>> mutators = ProdCharacteristicMutatorProvider.createMutators();

    private static List<FuzzingMutator<ProdCharacteristic>> createMutators() {
        LinkedList<FuzzingMutator<ProdCharacteristic>> mutators = new LinkedList<FuzzingMutator<ProdCharacteristic>>();
        mutators.add((ctx, pc) -> ctx.fuzzIdElement(ProdCharacteristic.class, pc));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getExtension()));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getModifierExtension()));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getColor()));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getImage()));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getImprint()));
        mutators.add((ctx, bt) -> ctx.fuzzChild(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getDepth()));
        mutators.add((ctx, bt) -> ctx.fuzzChild(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getHeight()));
        mutators.add((ctx, bt) -> ctx.fuzzChild(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getExternalDiameter()));
        mutators.add((ctx, bt) -> ctx.fuzzChild(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getShapeElement()));
        mutators.add((ctx, bt) -> ctx.fuzzChild(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getScoring()));
        mutators.add((ctx, bt) -> ctx.fuzzChild(ProdCharacteristic.class, ProdCharacteristicMutatorProvider.ensureNotNull(ctx.randomness(), bt).getNominalVolume()));
        return mutators;
    }

    private static ProdCharacteristic ensureNotNull(Randomness randomness, ProdCharacteristic prodCharacteristic) {
        if (prodCharacteristic == null) {
            prodCharacteristic = randomness.fhir().createType(ProdCharacteristic.class);
        }
        return prodCharacteristic;
    }

    @Override
    @Generated
    public List<FuzzingMutator<ProdCharacteristic>> getMutators() {
        return this.mutators;
    }
}

