/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.PositiveIntType;

public class PositiveIntTypeMutatorProvider
implements FhirTypeMutatorProvider<PositiveIntType> {
    private final List<FuzzingMutator<PositiveIntType>> mutators = PositiveIntTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<PositiveIntType>> createMutators() {
        LinkedList<FuzzingMutator<PositiveIntType>> mutators = new LinkedList<FuzzingMutator<PositiveIntType>>();
        mutators.add((ctx, pit) -> ctx.fuzzIdElement(PositiveIntType.class, pit));
        mutators.add((ctx, pit) -> ctx.fuzzChildTypes(PositiveIntType.class, PositiveIntTypeMutatorProvider.ensureNotNull(ctx.randomness(), pit).getExtension()));
        mutators.add((ctx, pit) -> {
            pit = PositiveIntTypeMutatorProvider.ensureNotNull(ctx.randomness(), pit);
            pit.setValue((Object)ctx.randomness().source().nextInt(0, Integer.MAX_VALUE));
            return FuzzingLogEntry.operation("Fuzz PositiveIntType");
        });
        return mutators;
    }

    private static PositiveIntType ensureNotNull(Randomness randomness, PositiveIntType pit) {
        if (pit == null) {
            pit = randomness.fhir().createType(PositiveIntType.class);
        }
        return pit;
    }

    @Override
    @Generated
    public List<FuzzingMutator<PositiveIntType>> getMutators() {
        return this.mutators;
    }
}

