/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Population;

public class PopulationMutatorProvider
implements FhirTypeMutatorProvider<Population> {
    private final List<FuzzingMutator<Population>> mutators = PopulationMutatorProvider.createMutators();

    private static List<FuzzingMutator<Population>> createMutators() {
        LinkedList<FuzzingMutator<Population>> mutators = new LinkedList<FuzzingMutator<Population>>();
        mutators.add((ctx, population) -> ctx.fuzzIdElement(Population.class, population));
        mutators.add((ctx, population) -> ctx.fuzzChildTypes(Population.class, PopulationMutatorProvider.ensureNotNull(ctx.randomness(), population).getExtension()));
        mutators.add((ctx, population) -> ctx.fuzzChildTypes(Population.class, PopulationMutatorProvider.ensureNotNull(ctx.randomness(), population).getModifierExtension()));
        mutators.add((ctx, population) -> ctx.fuzzChild(Population.class, PopulationMutatorProvider.ensureNotNull(ctx.randomness(), population).getAge()));
        mutators.add((ctx, population) -> ctx.fuzzChild(Population.class, PopulationMutatorProvider.ensureNotNull(ctx.randomness(), population).getGender()));
        mutators.add((ctx, population) -> ctx.fuzzChild(Population.class, PopulationMutatorProvider.ensureNotNull(ctx.randomness(), population).getRace()));
        mutators.add((ctx, population) -> ctx.fuzzChild(Population.class, PopulationMutatorProvider.ensureNotNull(ctx.randomness(), population).getPhysiologicalCondition()));
        return mutators;
    }

    private static Population ensureNotNull(Randomness randomness, Population population) {
        if (population == null) {
            population = randomness.fhir().createType(Population.class);
        }
        return population;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Population>> getMutators() {
        return this.mutators;
    }
}

