/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Period;

public class PeriodTypeMutatorProvider
implements FhirTypeMutatorProvider<Period> {
    private final List<FuzzingMutator<Period>> mutators = PeriodTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Period>> createMutators() {
        LinkedList<FuzzingMutator<Period>> mutators = new LinkedList<FuzzingMutator<Period>>();
        mutators.add((ctx, period) -> ctx.fuzzIdElement(Period.class, period));
        mutators.add((ctx, period) -> ctx.fuzzChildTypes(Period.class, PeriodTypeMutatorProvider.ensureNotNull(ctx.randomness(), period).getExtension()));
        mutators.add((ctx, period) -> ctx.fuzzChild(Period.class, PeriodTypeMutatorProvider.ensureNotNull(ctx.randomness(), period).getStartElement()));
        mutators.add((ctx, period) -> ctx.fuzzChild(Period.class, PeriodTypeMutatorProvider.ensureNotNull(ctx.randomness(), period).getEndElement()));
        return mutators;
    }

    private static Period ensureNotNull(Randomness randomness, Period period) {
        if (period == null) {
            period = randomness.fhir().createType(Period.class);
        }
        return period;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Period>> getMutators() {
        return this.mutators;
    }
}

