/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.ParameterDefinition;

public class ParameterDefinitionMutatorProvider
implements FhirTypeMutatorProvider<ParameterDefinition> {
    private final List<FuzzingMutator<ParameterDefinition>> mutators = ParameterDefinitionMutatorProvider.createMutators();

    private static List<FuzzingMutator<ParameterDefinition>> createMutators() {
        LinkedList<FuzzingMutator<ParameterDefinition>> mutators = new LinkedList<FuzzingMutator<ParameterDefinition>>();
        mutators.add((ctx, pd) -> ctx.fuzzIdElement(ParameterDefinition.class, pd));
        mutators.add((ctx, pd) -> ctx.fuzzChildTypes(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getExtension()));
        mutators.add((ctx, pd) -> ctx.fuzzChild(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getTypeElement()));
        mutators.add((ctx, pd) -> ctx.fuzzChild(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getDocumentationElement()));
        mutators.add((ctx, pd) -> ctx.fuzzChild(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getMaxElement()));
        mutators.add((ctx, pd) -> ctx.fuzzChild(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getMinElement()));
        mutators.add((ctx, pd) -> ctx.fuzzChild(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getNameElement()));
        mutators.add((ctx, pd) -> ctx.fuzzChild(ParameterDefinition.class, ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd).getProfileElement()));
        mutators.add((ctx, pd) -> {
            pd = ParameterDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), pd);
            ParameterDefinition.ParameterUse use = pd.getUse();
            ParameterDefinition.ParameterUse fuse = ctx.randomness().chooseRandomFromEnum(ParameterDefinition.ParameterUse.class, use);
            pd.setUse(fuse);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Use of ParameterDefinition {0}: {1} -> {2}", pd.getId(), use, fuse));
        });
        return mutators;
    }

    private static ParameterDefinition ensureNotNull(Randomness randomness, ParameterDefinition pd) {
        if (pd == null) {
            pd = randomness.fhir().createType(ParameterDefinition.class);
        }
        return pd;
    }

    @Override
    @Generated
    public List<FuzzingMutator<ParameterDefinition>> getMutators() {
        return this.mutators;
    }
}

