/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Narrative;

public class NarrativeMutatorProvider
implements FhirTypeMutatorProvider<Narrative> {
    private final List<FuzzingMutator<Narrative>> mutators = NarrativeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Narrative>> createMutators() {
        LinkedList<FuzzingMutator<Narrative>> mutators = new LinkedList<FuzzingMutator<Narrative>>();
        mutators.add((ctx, narrative) -> ctx.fuzzIdElement(Narrative.class, narrative));
        mutators.add((ctx, narrative) -> ctx.fuzzChildTypes(Narrative.class, NarrativeMutatorProvider.ensureNotNull(ctx.randomness(), narrative).getExtension()));
        mutators.add((ctx, narrative) -> {
            narrative = NarrativeMutatorProvider.ensureNotNull(ctx.randomness(), narrative);
            Narrative.NarrativeStatus ons = narrative.getStatus();
            Narrative.NarrativeStatus fns = ctx.randomness().chooseRandomFromEnum(Narrative.NarrativeStatus.class, ons);
            narrative.setStatus(fns);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Status of Narrative {0}: {1} -> {2}", narrative.getId(), ons, fns));
        });
        return mutators;
    }

    private static Narrative ensureNotNull(Randomness randomness, Narrative narrative) {
        if (narrative == null) {
            narrative = randomness.fhir().createType(Narrative.class);
        }
        if (!narrative.hasStatus()) {
            narrative.setStatus(Narrative.NarrativeStatus.GENERATED);
        }
        return narrative;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Narrative>> getMutators() {
        return this.mutators;
    }
}

