/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Money;

public class MoneyMutatorProvider
implements FhirTypeMutatorProvider<Money> {
    private final List<FuzzingMutator<Money>> mutators = MoneyMutatorProvider.createMutators();

    private static List<FuzzingMutator<Money>> createMutators() {
        LinkedList<FuzzingMutator<Money>> mutators = new LinkedList<FuzzingMutator<Money>>();
        mutators.add((ctx, money) -> ctx.fuzzIdElement(Money.class, money));
        mutators.add((ctx, money) -> ctx.fuzzChildTypes(Money.class, MoneyMutatorProvider.ensureNotNull(ctx.randomness(), money).getExtension()));
        mutators.add((ctx, money) -> ctx.fuzzChild(Money.class, MoneyMutatorProvider.ensureNotNull(ctx.randomness(), money).getCurrencyElement()));
        mutators.add((ctx, money) -> ctx.fuzzChild(Money.class, MoneyMutatorProvider.ensureNotNull(ctx.randomness(), money).getValueElement()));
        return mutators;
    }

    private static Money ensureNotNull(Randomness randomness, Money money) {
        if (money == null) {
            money = randomness.fhir().createType(Money.class);
        }
        return money;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Money>> getMutators() {
        return this.mutators;
    }
}

