/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Meta;

public class MetaTypeMutatorProvider
implements FhirTypeMutatorProvider<Meta> {
    private final List<FuzzingMutator<Meta>> mutators = MetaTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Meta>> createMutators() {
        LinkedList<FuzzingMutator<Meta>> mutators = new LinkedList<FuzzingMutator<Meta>>();
        mutators.add((ctx, meta) -> ctx.fuzzIdElement(Meta.class, meta));
        mutators.add((ctx, meta) -> ctx.fuzzChild(Meta.class, MetaTypeMutatorProvider.ensureNotNull(ctx.randomness(), meta).getVersionIdElement()));
        mutators.add((ctx, meta) -> ctx.fuzzChildTypes(Meta.class, MetaTypeMutatorProvider.ensureNotNull(ctx.randomness(), meta).getExtension()));
        mutators.add((ctx, meta) -> ctx.fuzzChildTypes(Meta.class, MetaTypeMutatorProvider.ensureNotNull(ctx.randomness(), meta).getSecurity()));
        mutators.add((ctx, meta) -> ctx.fuzzChildTypes(Meta.class, MetaTypeMutatorProvider.ensureNotNull(ctx.randomness(), meta).getProfile()));
        mutators.add((ctx, meta) -> ctx.fuzzChildTypes(Meta.class, MetaTypeMutatorProvider.ensureNotNull(ctx.randomness(), meta).getTag()));
        mutators.add((ctx, meta) -> {
            meta = MetaTypeMutatorProvider.ensureNotNull(ctx.randomness(), meta);
            int amount = ctx.randomness().source().nextInt(1, 2);
            LinkedList<FuzzingLogEntry> children = new LinkedList<FuzzingLogEntry>();
            for (int i = 0; i < amount; ++i) {
                String uuid = ctx.randomness().uuid();
                CanonicalType profile = new CanonicalType(ctx.randomness().url(uuid));
                meta.getProfile().add(profile);
                children.add(ctx.fuzzChild("Fuzz new random Profile for Meta", profile));
            }
            return FuzzingLogEntry.parent("Add randomly Profiles to Meta", children);
        });
        return mutators;
    }

    private static Meta ensureNotNull(Randomness randomness, Meta meta) {
        if (meta == null) {
            meta = randomness.fhir().createType(Meta.class);
        }
        return meta;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Meta>> getMutators() {
        return this.mutators;
    }
}

