/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.MarketingStatus;

public class MarketingStatusMutatorProvider
implements FhirTypeMutatorProvider<MarketingStatus> {
    private final List<FuzzingMutator<MarketingStatus>> mutators = MarketingStatusMutatorProvider.createMutators();

    private static List<FuzzingMutator<MarketingStatus>> createMutators() {
        LinkedList<FuzzingMutator<MarketingStatus>> mutators = new LinkedList<FuzzingMutator<MarketingStatus>>();
        mutators.add((ctx, ms) -> ctx.fuzzIdElement(MarketingStatus.class, ms));
        mutators.add((ctx, ms) -> ctx.fuzzChildTypes(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getExtension()));
        mutators.add((ctx, ms) -> ctx.fuzzChildTypes(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getModifierExtension()));
        mutators.add((ctx, ms) -> ctx.fuzzChild(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getStatus()));
        mutators.add((ctx, ms) -> ctx.fuzzChild(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getCountry()));
        mutators.add((ctx, ms) -> ctx.fuzzChild(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getJurisdiction()));
        mutators.add((ctx, ms) -> ctx.fuzzChild(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getDateRange()));
        mutators.add((ctx, ms) -> ctx.fuzzChild(MarketingStatus.class, MarketingStatusMutatorProvider.ensureNotNull(ctx.randomness(), ms).getRestoreDateElement()));
        return mutators;
    }

    private static MarketingStatus ensureNotNull(Randomness randomness, MarketingStatus marketingStatus) {
        if (marketingStatus == null) {
            marketingStatus = randomness.fhir().createType(MarketingStatus.class);
        }
        return marketingStatus;
    }

    @Override
    @Generated
    public List<FuzzingMutator<MarketingStatus>> getMutators() {
        return this.mutators;
    }
}

